/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.bukkit.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.hsgamer.morefoworld.core.bukkit.utils.VersionUtils;
import me.hsgamer.morefoworld.core.common.CollectionUtils;
import me.hsgamer.morefoworld.core.common.StringUtils;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public final class ColorUtils {
    private static final Pattern hybridColorPattern = Pattern.compile("(\\\\?)((\\S)\\(#([A-Fa-f\\d]{1,6}),([a-zA-Z\\d])\\))");
    private static final Map<Character, Supplier<Character>> colorMappers = Collections.singletonMap(Character.valueOf('u'), () -> Character.valueOf(ColorUtils.getRandomColor().getChar()));
    private static BooleanSupplier hexSupportGlobalCheck = () -> VersionUtils.isAtLeast(16);

    private ColorUtils() {
    }

    @NotNull
    public static String replaceHybridColorCode(char indicator, String input) {
        return StringUtils.replacePattern(input, hybridColorPattern, matcher -> {
            String matchedChar = matcher.group(3);
            if (matchedChar.indexOf(indicator) < 0) {
                return null;
            }
            boolean skip = matcher.group(1).equals("\\");
            if (skip) {
                return matcher.group(2);
            }
            if (hexSupportGlobalCheck.getAsBoolean()) {
                return indicator + "#" + matcher.group(4);
            }
            return indicator + matcher.group(5);
        });
    }

    @NotNull
    public static String colorize(@NotNull String input) {
        char colorChar = '&';
        return ColorUtils.colorize(colorChar, ColorUtils.colorizeHex(colorChar, ColorUtils.replaceHybridColorCode(colorChar, input)));
    }

    @NotNull
    public static String colorizeHex(char altColorChar, @NotNull String input) {
        return StringUtils.replaceHex(altColorChar, hex -> "\u00a7x\u00a7" + hex[0] + '\u00a7' + hex[1] + '\u00a7' + hex[2] + '\u00a7' + hex[3] + '\u00a7' + hex[4] + '\u00a7' + hex[5], input);
    }

    @NotNull
    public static String colorize(char altColorChar, @NotNull String input) {
        return StringUtils.replaceChar(altColorChar, '\u00a7', input, colorMappers);
    }

    @NotNull
    public static ChatColor getRandomColor() {
        return Objects.requireNonNull(CollectionUtils.pickRandom(ChatColor.values(), ChatColor::isColor));
    }

    public static void setHexSupportGlobalCheck(BooleanSupplier hexSupportGlobalCheck) {
        ColorUtils.hexSupportGlobalCheck = hexSupportGlobalCheck;
    }
}

