/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public interface PathString {
    public static final String DEFAULT_SEPARATOR = ".";

    public static String[] asArray(String path) {
        return new String[]{path};
    }

    public static String[] concat(String[] a1, String[] a2) {
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    public static String join(String separator, String ... path) {
        return String.join((CharSequence)separator, path);
    }

    public static String[] split(String separator, String path) {
        return path.split(Pattern.quote(separator));
    }

    public static Map<String, Object> join(String separator, Map<String[], Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String[], Object> entry : map.entrySet()) {
            result.put(PathString.join(separator, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Map<String[], Object> split(String separator, Map<String, Object> map) {
        LinkedHashMap<String[], Object> result = new LinkedHashMap<String[], Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            result.put(PathString.split(separator, entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static String joinDefault(String ... path) {
        return PathString.join(DEFAULT_SEPARATOR, path);
    }

    public static String[] splitDefault(String path) {
        return PathString.split(DEFAULT_SEPARATOR, path);
    }

    public static Map<String, Object> joinDefault(Map<String[], Object> map) {
        return PathString.join(DEFAULT_SEPARATOR, map);
    }

    public static Map<String[], Object> splitDefault(Map<String, Object> map) {
        return PathString.split(DEFAULT_SEPARATOR, map);
    }
}

