/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.core.config.annotation.converter.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import me.hsgamer.morefoworld.core.config.annotation.converter.Converter;
import me.hsgamer.morefoworld.core.config.annotation.converter.ConverterProvider;
import me.hsgamer.morefoworld.core.config.annotation.converter.impl.SimpleConverter;

public class PrimitiveConverterProvider
implements ConverterProvider {
    private static Class<?> getBoxedClass(Class<?> primitiveClass) {
        if (primitiveClass == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveClass == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveClass == Short.TYPE) {
            return Short.class;
        }
        if (primitiveClass == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveClass == Long.TYPE) {
            return Long.class;
        }
        if (primitiveClass == Float.TYPE) {
            return Float.class;
        }
        if (primitiveClass == Double.TYPE) {
            return Double.class;
        }
        if (primitiveClass == Character.TYPE) {
            return Character.class;
        }
        return null;
    }

    @Override
    public Optional<Converter> getConverter(Class<?> type) {
        Function<String, Object> converter;
        Class<?> boxedClass;
        boolean isPrimitive = type.isPrimitive();
        Class<?> clazz = boxedClass = isPrimitive ? PrimitiveConverterProvider.getBoxedClass(type) : type;
        if (boxedClass == null) {
            return Optional.empty();
        }
        if (boxedClass == Boolean.class) {
            converter = Boolean::parseBoolean;
        } else if (boxedClass == Byte.class) {
            converter = s -> {
                try {
                    return Byte.parseByte(s);
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Short.class) {
            converter = s -> {
                try {
                    return Short.parseShort(s);
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Integer.class) {
            converter = s -> {
                try {
                    return Integer.parseInt(s);
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Long.class) {
            converter = s -> {
                try {
                    return Long.parseLong(s);
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Float.class) {
            converter = s -> {
                try {
                    return Float.valueOf(Float.parseFloat(s));
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Double.class) {
            converter = s -> {
                try {
                    return Double.parseDouble(s);
                }
                catch (Exception e) {
                    return null;
                }
            };
        } else if (boxedClass == Character.class) {
            converter = s -> {
                if (s.length() == 1) {
                    return Character.valueOf(s.charAt(0));
                }
                return null;
            };
        } else {
            return Optional.empty();
        }
        return Optional.of(new SimpleConverter(o -> {
            String string = Objects.toString(o, "");
            return converter.apply(string);
        }));
    }
}

