/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.listener;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.morefoworld.DebugComponent;
import me.hsgamer.morefoworld.config.PortalConfig;
import me.hsgamer.morefoworld.minelib.plugin.base.BasePlugin;
import me.hsgamer.morefoworld.minelib.plugin.listener.ListenerComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class PortalListener
implements ListenerComponent {
    private final ConcurrentHashMap<UUID, Material> portalTeleportCache = new ConcurrentHashMap();
    private final BasePlugin plugin;
    private DebugComponent debug;

    public PortalListener(BasePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BasePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.debug = this.plugin.get(DebugComponent.class);
    }

    @EventHandler
    public void onPortalReady(EntityPortalReadyEvent event) {
        if (event.getPortalType() != PortalType.NETHER) {
            return;
        }
        this.debug.debug("Portal Ready: " + String.valueOf(event.getEntity().getWorld()));
        this.debug.debug("Portal Type: " + String.valueOf(event.getPortalType()));
        this.plugin.get(PortalConfig.class).getWorldFromNetherPortal(event.getEntity().getWorld()).ifPresent(world -> {
            event.setTargetWorld(world);
            this.debug.debug("Set Portal to " + String.valueOf(world));
        });
    }

    private CompletableFuture<Void> constructEndPlatform(Location location) {
        return CompletableFuture.runAsync(() -> {
            Block block = location.getBlock();
            for (int x = block.getX() - 2; x <= block.getX() + 2; ++x) {
                for (int z = block.getZ() - 2; z <= block.getZ() + 2; ++z) {
                    Block platformBlock = block.getWorld().getBlockAt(x, block.getY() - 1, z);
                    if (platformBlock.getType() != Material.OBSIDIAN) {
                        platformBlock.setType(Material.OBSIDIAN);
                    }
                    for (int yMod = 1; yMod <= 3; ++yMod) {
                        Block b = platformBlock.getRelative(BlockFace.UP, yMod);
                        if (b.getType() == Material.AIR) continue;
                        b.setType(Material.AIR);
                    }
                }
            }
        }, runnable -> Bukkit.getRegionScheduler().execute((Plugin)this.plugin, location, runnable));
    }

    private CompletableFuture<Void> constructNetherPortal(Location location) {
        return CompletableFuture.runAsync(() -> {}, runnable -> Bukkit.getRegionScheduler().execute((Plugin)this.plugin, location, runnable));
    }

    private CompletableFuture<Boolean> teleport(Entity entity, Location location, boolean runInScheduler) {
        if (runInScheduler) {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            entity.getScheduler().execute((Plugin)this.plugin, () -> entity.teleportAsync(location).thenAccept(future::complete), null, 1L);
            return future;
        }
        return entity.teleportAsync(location);
    }

    @EventHandler
    public void onPlayerPortal(PlayerPortalEvent event) {
        if (event.getCause() != PlayerTeleportEvent.TeleportCause.END_PORTAL) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        this.debug.debug("Portal Cause: " + String.valueOf(event.getCause()));
        this.debug.debug("From: " + String.valueOf(from));
        this.debug.debug("To: " + String.valueOf(to));
        Optional<World> worldOptional = this.plugin.get(PortalConfig.class).getWorldFromEndPortal(from.getWorld());
        worldOptional.ifPresent(world -> {
            Location clone = to.clone();
            clone.setWorld(world);
        });
    }

    @EventHandler
    public void onEntityPortal(EntityPortalEvent event) {
        if (event.getPortalType() != PortalType.ENDER) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        this.debug.debug("Entity Portal: " + String.valueOf(event.getPortalType()));
        this.debug.debug("From: " + String.valueOf(from));
        this.debug.debug("To: " + String.valueOf(to));
        if (to == null) {
            return;
        }
        Optional<World> worldOptional = this.plugin.get(PortalConfig.class).getWorldFromEndPortal(from.getWorld());
        worldOptional.ifPresent(world -> {
            Location clone = to.clone();
            clone.setWorld(world);
            event.setCancelled(true);
            CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
            if (world.getEnvironment() == World.Environment.THE_END) {
                future = this.constructEndPlatform(clone);
            }
            ((CompletableFuture)future.thenCompose(aVoid -> this.teleport(event.getEntity(), clone, true))).thenRun(() -> this.debug.debug("Teleported to " + String.valueOf(clone)));
        });
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityInsidePortal(EntityInsideBlockEvent event) {
        Optional toWorldOptional;
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        Material blockTypeInside = block.getType();
        Location from = entity.getLocation();
        if (this.portalTeleportCache.containsKey(entity.getUniqueId())) {
            this.debug.debug("The entity is being teleported");
            return;
        }
        switch (blockTypeInside) {
            case NETHER_PORTAL: {
                Optional<Object> optional = this.plugin.get(PortalConfig.class).getWorldFromNetherPortal(from.getWorld());
                break;
            }
            case END_PORTAL: {
                Optional<Object> optional = this.plugin.get(PortalConfig.class).getWorldFromEndPortal(from.getWorld());
                break;
            }
            default: {
                Optional<Object> optional = toWorldOptional = Optional.empty();
            }
        }
        if (toWorldOptional.isEmpty()) {
            return;
        }
        World toWorld = (World)toWorldOptional.get();
        this.portalTeleportCache.put(entity.getUniqueId(), blockTypeInside);
        event.setCancelled(true);
        entity.getScheduler().execute((Plugin)this.plugin, () -> {
            Location to;
            Block currentBlock = entity.getLocation().getBlock();
            if (currentBlock.getType() != blockTypeInside) {
                this.debug.debug("The entity is not in the portal");
                this.portalTeleportCache.remove(entity.getUniqueId());
                return;
            }
            World.Environment fromEnvironment = from.getWorld().getEnvironment();
            World.Environment toEnvironment = toWorld.getEnvironment();
            if (toEnvironment == World.Environment.THE_END) {
                to = toWorld.getSpawnLocation();
            } else if (fromEnvironment == World.Environment.NORMAL && toEnvironment == World.Environment.NETHER) {
                to = from.clone();
                to.setWorld(toWorld);
                to.setX(to.getX() / 8.0);
                to.setZ(to.getZ() / 8.0);
            } else if (fromEnvironment == World.Environment.NETHER && toEnvironment == World.Environment.NORMAL) {
                to = from.clone();
                to.setWorld(toWorld);
                to.setX(to.getX() * 8.0);
                to.setZ(to.getZ() * 8.0);
            } else {
                to = from.clone();
                to.setWorld(toWorld);
            }
            switch (toEnvironment) {
                case THE_END: {
                    ((CompletableFuture)this.constructEndPlatform(to).thenCompose(aVoid -> this.teleport(entity, to, false))).thenRun(() -> this.debug.debug("Teleported to " + String.valueOf(to)));
                    break;
                }
                case NETHER: {
                    ((CompletableFuture)this.constructNetherPortal(to).thenCompose(aVoid -> this.teleport(entity, to, false))).thenRun(() -> this.debug.debug("Teleported to " + String.valueOf(to)));
                    break;
                }
                default: {
                    this.teleport(entity, to, false).thenRun(() -> this.debug.debug("Teleported to " + String.valueOf(to)));
                }
            }
            this.portalTeleportCache.remove(entity.getUniqueId());
        }, null, 1L);
    }
}

