/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.listener;

import java.util.Optional;
import me.hsgamer.morefoworld.DebugComponent;
import me.hsgamer.morefoworld.config.RespawnConfig;
import me.hsgamer.morefoworld.config.WorldSpawnConfig;
import me.hsgamer.morefoworld.minelib.plugin.base.BasePlugin;
import me.hsgamer.morefoworld.minelib.plugin.listener.ListenerComponent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class RespawnListener
implements ListenerComponent {
    private final BasePlugin plugin;
    private DebugComponent debug;

    public RespawnListener(BasePlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public BasePlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void load() {
        this.debug = this.plugin.get(DebugComponent.class);
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Location location = player.getLocation();
        this.debug.debug("Death: " + player.getName() + " at " + String.valueOf(location));
        World world = location.getWorld();
        Optional<World> optionalRespawnWorld = this.plugin.get(RespawnConfig.class).getRespawnWorld(world);
        if (optionalRespawnWorld.isEmpty()) {
            return;
        }
        World respawnWorld = optionalRespawnWorld.get();
        Location respawnLocation = this.plugin.get(WorldSpawnConfig.class).getSpawn(world).map(position -> position.toLocation(world)).orElseGet(() -> ((World)world).getSpawnLocation());
        this.debug.debug("Set Respawn to " + String.valueOf(respawnWorld));
        player.getScheduler().runAtFixedRate((Plugin)this.plugin, task -> {
            if (player.isDead()) {
                return;
            }
            task.cancel();
            player.teleportAsync(respawnLocation);
            this.debug.debug("Respawned: " + player.getName() + " at " + String.valueOf(respawnLocation));
        }, null, 1L, 1L);
        this.debug.debug("Scheduled Respawn");
    }
}

