/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.morefoworld.minelib.util.subcommand;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubCommand {
    protected final String name;
    protected boolean consoleAllowed;
    protected String permission;
    protected String usage;
    protected String description;
    protected BiConsumer<String, CommandSender> usageSender = (label, sender) -> sender.sendMessage(this.getUsage().replace("<label>", (CharSequence)label));
    protected Consumer<CommandSender> playerOnlyMessageSender = sender -> sender.sendMessage(ChatColor.RED + "You have to be a player to do this");
    protected Consumer<CommandSender> noPermissionMessageSender = sender -> sender.sendMessage(ChatColor.RED + "You don't have permission to do this");

    protected SubCommand(@NotNull String name) {
        this.name = name;
        this.consoleAllowed = true;
        this.permission = null;
        this.usage = "";
        this.description = "";
    }

    protected SubCommand(@NotNull String name, @NotNull String description, @NotNull String usage, @Nullable String permission, boolean consoleAllowed) {
        this.name = name;
        this.permission = permission;
        this.description = description;
        this.usage = usage;
        this.consoleAllowed = consoleAllowed;
    }

    public final boolean isExecutable(@NotNull CommandSender sender, boolean sendMessageIfFalse) {
        if (sender instanceof ConsoleCommandSender && !this.consoleAllowed) {
            if (sendMessageIfFalse) {
                this.playerOnlyMessageSender.accept(sender);
            }
            return false;
        }
        if (this.permission != null && !sender.hasPermission(this.permission)) {
            if (sendMessageIfFalse) {
                this.noPermissionMessageSender.accept(sender);
            }
            return false;
        }
        return true;
    }

    public final boolean onCommand(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        if (!this.isExecutable(sender, true)) {
            return false;
        }
        if (!this.isProperUsage(sender, label, args)) {
            this.usageSender.accept(label, sender);
            return false;
        }
        this.onSubCommand(sender, label, args);
        return true;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String description) {
        this.description = description;
    }

    @NotNull
    public final String getUsage() {
        return this.usage;
    }

    public final void setUsage(@NotNull String usage) {
        this.usage = usage;
    }

    @Nullable
    public final String getPermission() {
        return this.permission;
    }

    public final void setPermission(@Nullable String permission) {
        this.permission = permission;
    }

    public final void setPermission(@NotNull Permission permission) {
        this.permission = permission.getName();
    }

    public final boolean isConsoleAllowed() {
        return this.consoleAllowed;
    }

    public final void setConsoleAllowed(boolean consoleAllowed) {
        this.consoleAllowed = consoleAllowed;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public abstract void onSubCommand(@NotNull CommandSender var1, @NotNull String var2, String ... var3);

    public boolean isProperUsage(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull String label, String ... args) {
        return Collections.emptyList();
    }
}

