let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

// Add custom ability
StartupEvents.registry('palladium:abilities', (event) => {

    // ID of the ability will be: 'kubejs:jump/boost'
    event.create('jump/boost')

        // Preset icon, can also be changed individually in the power json
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

        //credit 
        .documentationDescription('Leap ability made by sheriff1919 ,slightly edit')

        //property 
        .addProperty("power", "integer", 1, "The amount strength of the leap")

        // Handler for what happens during EVERY tick of the ability being active, make sure to check the 'enabled' parameter
        .firstTick((entity, entry, holder, enabled) => {
            if (enabled) {
                const power = entry.getPropertyByName("power");
                let move = entity.getLookAngle().scale(power);
                entity.setDeltaMovement(move);

                if (entity.isPlayer()) {
                    entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
                }
            }
        })
});