const ExpPower = [
    'spring:mcu_mk2'
];

const BlockedEffects = [
    'spring_core:emp',
    'spring_core:frozen',
    'spring_core:freeze'
];

const BAR_TEXTURE = 'minecraft:textures/gui/bars.png';

PalladiumEvents.registerGuiOverlays((event) => {
    event.register(
        'spring:iron_man_hud',

        (minecraft, gui, poseStack, partialTick, screenWidth, screenHeight) => {
            let player = minecraft.player;
            let playerName = player.getGameProfile().getName();
            if (!player) return;

            let power = palladium.powers.getPowerIds(player);
            if (!power || power.length === 0) return;

            let rawPowerId = power[0].toString();
            let firstpower = rawPowerId.split(":").pop();

            if (ExpPower.includes(rawPowerId)) {
                for (let i = 0; i < BlockedEffects.length; i++) {
                    if (player.hasEffect(BlockedEffects[i])) return;
                }

                let altitude = Math.floor(player.getY());
                let X = Math.floor(player.getX());
                let Z = Math.floor(player.getZ());
                let color

                if (altitude >= 180) {
                    color = 0xf80303
                    guiUtil.drawString(
                        poseStack,
                        Component.string(`Suit is reaching it's limit going higher might cause freezing`),
                        80,
                        10,
                        color
                    );
                } else if (altitude >= 140 && altitude <= 180) {
                    color = 0xffff00
                } else {
                    color = 0xFDFAFA
                }

                guiUtil.drawString(
                    poseStack,
                    Component.string(`Altitude: ${altitude}`),
                    0,
                    20,
                    color
                );

                guiUtil.drawString(
                    poseStack,
                    Component.string(`X:${X} Y:${altitude} Z:${Z}`),
                    0,
                    30,
                    0xFDFAFA
                );

                let scoreboard = Utils.server.scoreboard;
                let rfName = "Spring.RFsuit";
                let rfMName = "Spring.MaxRFsuit";
                let rfObjective = scoreboard.getObjective(rfName);
                let rfMObjective = scoreboard.getObjective(rfMName);
                let rfscoreboard = scoreboard.getOrCreatePlayerScore(playerName, rfObjective);
                let rfMscoreboard = scoreboard.getOrCreatePlayerScore(playerName, rfMObjective);

                let energy = rfscoreboard.getScore();
                let maxEnergy = rfMscoreboard.getScore();

                let percent = Math.floor((energy / maxEnergy) * 100);
                let warningenergycolor = 0x00ffff

                guiUtil.drawString(
                    poseStack, Component.string(`Energy: ${energy}/${maxEnergy}`), 0, 40, 0x00ffff
                );

                if (percent == 50 || percent == 15  || percent == 10 || percent <= 5) {
                    warningenergycolor = 0x00ffff
                    if (percent == 15) {
                        warningenergycolor = 0xfdad17
                    }else if (percent == 10){
                        warningenergycolor = 0xff6200
                    }else if(percent <= 5){
                        warningenergycolor = 0xff0000
                    }

                    guiUtil.drawString(
                        poseStack, Component.string(`${percent}%`), 0, 50, warningenergycolor
                    );
                }



            }
        }
    );
});
