/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.LockManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class LockListener
implements Listener {
    private final LockManager lockManager;

    public LockListener(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && this.lockManager.isContainer(event.getClickedBlock()) && this.lockManager.isLocked(event.getClickedBlock().getLocation()) && !this.lockManager.canAccess(event.getPlayer(), event.getClickedBlock().getLocation())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("This container is locked.");
            UUID ownerUUID = this.lockManager.getLock(event.getClickedBlock().getLocation()).getOwner();
            Player owner = Bukkit.getPlayer((UUID)ownerUUID);
            if (owner != null && owner.isOnline()) {
                owner.sendMessage(event.getPlayer().getName() + " tried to open your locked container.");
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.lockManager.isContainer(event.getBlock()) && this.lockManager.isLocked(event.getBlock().getLocation()) && !this.lockManager.isOwner(event.getPlayer(), event.getBlock().getLocation())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("You cannot break a locked container.");
        }
    }
}

