/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.ChestLock999;
import com.example.chestlock999.Lock;
import com.example.chestlock999.LockData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;

public class LockManager {
    private final ChestLock999 plugin;
    private final Map<Location, Lock> locks = new HashMap<Location, Lock>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public LockManager(ChestLock999 plugin) {
        this.plugin = plugin;
        this.loadLocks();
    }

    public void lock(Player player, Block block) {
        Location location = block.getLocation();
        if (this.isContainer(block) && !this.isLocked(location)) {
            this.locks.put(location, new Lock(player.getUniqueId()));
            player.sendMessage("Container locked.");
        } else {
            player.sendMessage("This is not a container or it is already locked.");
        }
    }

    public void unlock(Player player, Block block) {
        Location location = block.getLocation();
        if (this.isOwner(player, location)) {
            this.locks.remove(location);
            player.sendMessage("Container unlocked.");
        } else {
            player.sendMessage("You are not the owner of this container.");
        }
    }

    public void trust(Player player, String trustedPlayerName) {
        OfflinePlayer trustedPlayer = Bukkit.getOfflinePlayer((String)trustedPlayerName);
        if (trustedPlayer != null) {
            this.locks.values().stream().filter(lock -> lock.getOwner().equals(player.getUniqueId())).forEach(lock -> lock.addTrusted(trustedPlayer.getUniqueId()));
            player.sendMessage(trustedPlayerName + " has been trusted.");
        } else {
            player.sendMessage("Player not found.");
        }
    }

    public void untrust(Player player, String untrustedPlayerName) {
        OfflinePlayer untrustedPlayer = Bukkit.getOfflinePlayer((String)untrustedPlayerName);
        if (untrustedPlayer != null) {
            this.locks.values().stream().filter(lock -> lock.getOwner().equals(player.getUniqueId())).forEach(lock -> lock.removeTrusted(untrustedPlayer.getUniqueId()));
            player.sendMessage(untrustedPlayerName + " has been untrusted.");
        } else {
            player.sendMessage("Player not found.");
        }
    }

    public boolean isContainer(Block block) {
        return block.getState() instanceof Container;
    }

    public boolean isLocked(Location location) {
        return this.locks.containsKey(location);
    }

    public boolean isOwner(Player player, Location location) {
        return this.locks.containsKey(location) && this.locks.get(location).getOwner().equals(player.getUniqueId());
    }

    public boolean canAccess(Player player, Location location) {
        if (!this.isLocked(location)) {
            return true;
        }
        Lock lock = this.locks.get(location);
        return lock.getOwner().equals(player.getUniqueId()) || lock.isTrusted(player.getUniqueId());
    }

    public void loadLocks() {
        File dataFile = new File(this.plugin.getDataFolder(), "locks.json");
        if (dataFile.exists()) {
            try (FileReader reader = new FileReader(dataFile);){
                LockData lockData = (LockData)this.gson.fromJson((Reader)reader, LockData.class);
                if (lockData != null && lockData.getLocks() != null) {
                    this.locks.putAll(lockData.getLocks());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveLocks() {
        File dataFile = new File(this.plugin.getDataFolder(), "locks.json");
        try (FileWriter writer = new FileWriter(dataFile);){
            this.gson.toJson((Object)new LockData(this.locks), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Lock getLock(Location location) {
        return this.locks.get(location);
    }
}

