/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.LockCommand;
import com.example.chestlock999.LockInfoCommand;
import com.example.chestlock999.LockListCommand;
import com.example.chestlock999.LockListener;
import com.example.chestlock999.LockManager;
import com.example.chestlock999.LockTransferCommand;
import com.example.chestlock999.TrustCommand;
import com.example.chestlock999.TrustGroupCommand;
import com.example.chestlock999.UnlockCommand;
import com.example.chestlock999.UntrustCommand;
import com.example.chestlock999.UntrustGroupCommand;
import java.util.List;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestLock999
extends JavaPlugin {
    private LockManager lockManager;

    public void onEnable() {
        this.saveDefaultConfig();
        boolean defaultLockOnPlace = this.getConfig().getBoolean("default-lock-on-place", false);
        int maxLocksPerPlayer = this.getConfig().getInt("max-locks-per-player", 100);
        boolean notifyOnAttemptedAccess = this.getConfig().getBoolean("notify-on-attempted-access", true);
        List lockableBlocks = this.getConfig().getStringList("lockable-blocks");
        this.lockManager = new LockManager(this, defaultLockOnPlace, maxLocksPerPlayer, notifyOnAttemptedAccess, lockableBlocks);
        this.getCommand("lock").setExecutor((CommandExecutor)new LockCommand(this.lockManager));
        this.getCommand("unlock").setExecutor((CommandExecutor)new UnlockCommand(this.lockManager));
        this.getCommand("trust").setExecutor((CommandExecutor)new TrustCommand(this.lockManager));
        this.getCommand("untrust").setExecutor((CommandExecutor)new UntrustCommand(this.lockManager));
        this.getCommand("lockinfo").setExecutor((CommandExecutor)new LockInfoCommand(this.lockManager));
        this.getCommand("locklist").setExecutor((CommandExecutor)new LockListCommand(this.lockManager));
        this.getCommand("locktransfer").setExecutor((CommandExecutor)new LockTransferCommand(this.lockManager));
        this.getCommand("trustgroup").setExecutor((CommandExecutor)new TrustGroupCommand(this.lockManager));
        this.getCommand("untrustgroup").setExecutor((CommandExecutor)new UntrustGroupCommand(this.lockManager));
        this.getServer().getPluginManager().registerEvents((Listener)new LockListener(this.lockManager), (Plugin)this);
    }

    public void onDisable() {
        this.lockManager.saveLocks();
    }
}

