/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import java.util.HashSet;
import java.util.UUID;

public class Lock {
    private final UUID owner;
    private final HashSet<UUID> trusted = new HashSet();
    private final HashSet<String> trustedGroups = new HashSet();
    private final long creationDate;

    public Lock(UUID owner, long creationDate) {
        this.owner = owner;
        this.creationDate = creationDate;
    }

    public Lock(UUID owner) {
        this(owner, System.currentTimeMillis());
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isTrusted(UUID uuid) {
        return this.trusted.contains(uuid);
    }

    public HashSet<UUID> getTrusted() {
        return this.trusted;
    }

    public void addTrusted(UUID uuid) {
        this.trusted.add(uuid);
    }

    public void removeTrusted(UUID uuid) {
        this.trusted.remove(uuid);
    }

    public HashSet<String> getTrustedGroups() {
        return this.trustedGroups;
    }

    public void addTrustedGroup(String group) {
        this.trustedGroups.add(group);
    }

    public void removeTrustedGroup(String group) {
        this.trustedGroups.remove(group);
    }

    public long getCreationDate() {
        return this.creationDate;
    }
}

