/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.Lock;
import com.example.chestlock999.LockManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockInfoCommand
implements CommandExecutor {
    private final LockManager lockManager;

    public LockInfoCommand(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock == null || !this.lockManager.isContainer(targetBlock)) {
            player.sendMessage("You must be looking at a lockable container.");
            return true;
        }
        if (!this.lockManager.isLocked(targetBlock.getLocation())) {
            player.sendMessage("This container is not locked.");
            return true;
        }
        Lock lock = this.lockManager.getLock(targetBlock.getLocation());
        if (lock == null) {
            player.sendMessage("Error: Could not retrieve lock information.");
            return true;
        }
        player.sendMessage("\u00a76--- Lock Information ---");
        UUID ownerUUID = lock.getOwner();
        String ownerName = Bukkit.getOfflinePlayer((UUID)ownerUUID).getName();
        player.sendMessage("\u00a7eOwner: \u00a7f" + (ownerName != null ? ownerName : ownerUUID.toString()));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = sdf.format(new Date(lock.getCreationDate()));
        player.sendMessage("\u00a7eLocked On: \u00a7f" + formattedDate);
        if (!lock.getTrusted().isEmpty()) {
            StringBuilder trustedPlayers = new StringBuilder();
            for (UUID uuid : lock.getTrusted()) {
                String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                trustedPlayers.append(name != null ? name : uuid.toString()).append(", ");
            }
            player.sendMessage("\u00a7eTrusted Players: \u00a7f" + trustedPlayers.substring(0, trustedPlayers.length() - 2));
        } else {
            player.sendMessage("\u00a7eTrusted Players: \u00a7fNone");
        }
        if (!lock.getTrustedGroups().isEmpty()) {
            StringBuilder trustedGroups = new StringBuilder();
            for (String group : lock.getTrustedGroups()) {
                trustedGroups.append(group).append(", ");
            }
            player.sendMessage("\u00a7eTrusted Groups: \u00a7f" + trustedGroups.substring(0, trustedGroups.length() - 2));
        } else {
            player.sendMessage("\u00a7eTrusted Groups: \u00a7fNone");
        }
        player.sendMessage("\u00a76------------------------");
        return true;
    }
}

