/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.Lock;
import com.example.chestlock999.LockManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockListCommand
implements CommandExecutor {
    private final LockManager lockManager;

    public LockListCommand(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        Map<Location, Lock> allLocks = this.lockManager.getAllLocks();
        if (allLocks.isEmpty()) {
            player.sendMessage("\u00a7cThere are no locked containers on the server.");
            return true;
        }
        player.sendMessage("\u00a76--- Your Locked Containers ---");
        boolean foundLocks = false;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (Map.Entry<Location, Lock> entry : allLocks.entrySet()) {
            Lock lock = entry.getValue();
            if (!lock.getOwner().equals(playerUUID)) continue;
            foundLocks = true;
            Location loc = entry.getKey();
            String worldName = loc.getWorld() != null ? loc.getWorld().getName() : "Unknown";
            String formattedDate = sdf.format(new Date(lock.getCreationDate()));
            player.sendMessage("\u00a7e- " + loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ() + " (" + worldName + ") - Locked on: " + formattedDate);
        }
        if (!foundLocks) {
            player.sendMessage("\u00a7fYou do not own any locked containers.");
        }
        player.sendMessage("\u00a76----------------------------");
        return true;
    }
}

