/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.LockManager;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class LockListener
implements Listener {
    private final LockManager lockManager;

    public LockListener(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.lockManager.isDefaultLockOnPlace() && this.lockManager.isContainer(event.getBlock())) {
            this.lockManager.lock(event.getPlayer(), event.getBlock());
        }
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        event.blockList().removeIf(block -> this.lockManager.isLocked(block.getLocation()));
    }

    @EventHandler
    public void onPistonExtend(BlockPistonExtendEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.lockManager.isLocked(block.getLocation())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPistonRetract(BlockPistonRetractEvent event) {
        for (Block block : event.getBlocks()) {
            if (!this.lockManager.isLocked(block.getLocation())) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() != null && this.lockManager.isLocked(event.getClickedBlock().getLocation()) && !this.lockManager.canAccess(event.getPlayer(), event.getClickedBlock().getLocation())) {
            UUID ownerUUID;
            Player owner;
            event.setCancelled(true);
            event.getPlayer().sendMessage("This block is locked.");
            if (this.lockManager.isNotifyOnAttemptedAccess() && (owner = Bukkit.getPlayer((UUID)(ownerUUID = this.lockManager.getLock(event.getClickedBlock().getLocation()).getOwner()))) != null && owner.isOnline()) {
                owner.sendMessage(event.getPlayer().getName() + " tried to interact with your locked block.");
            }
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.lockManager.isLocked(event.getBlock().getLocation()) && !this.lockManager.isOwner(event.getPlayer(), event.getBlock().getLocation())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage("You cannot break a locked block.");
        }
    }
}

