/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.ChestLock999;
import com.example.chestlock999.Lock;
import com.example.chestlock999.LockData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;

public class LockManager {
    private final ChestLock999 plugin;
    private final Map<Location, Lock> locks = new HashMap<Location, Lock>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final boolean defaultLockOnPlace;
    private final int maxLocksPerPlayer;
    private final boolean notifyOnAttemptedAccess;
    private final List<String> lockableBlocks;

    public LockManager(ChestLock999 plugin, boolean defaultLockOnPlace, int maxLocksPerPlayer, boolean notifyOnAttemptedAccess, List<String> lockableBlocks) {
        this.plugin = plugin;
        this.defaultLockOnPlace = defaultLockOnPlace;
        this.maxLocksPerPlayer = maxLocksPerPlayer;
        this.notifyOnAttemptedAccess = notifyOnAttemptedAccess;
        this.lockableBlocks = lockableBlocks;
        this.loadLocks();
    }

    public void lock(Player player, Block block) {
        Location location = block.getLocation();
        if (this.isContainer(block)) {
            if (!this.isLocked(location)) {
                long ownedLocks = this.locks.values().stream().filter(lock -> lock.getOwner().equals(player.getUniqueId())).count();
                if (ownedLocks >= (long)this.maxLocksPerPlayer) {
                    player.sendMessage("You have reached your maximum lock limit (" + this.maxLocksPerPlayer + ").");
                    return;
                }
                this.locks.put(location, new Lock(player.getUniqueId()));
                player.sendMessage("Container locked.");
            } else {
                player.sendMessage("This container is already locked.");
            }
        } else {
            player.sendMessage("This is not a lockable container.");
        }
    }

    public void unlock(Player player, Block block) {
        Location location = block.getLocation();
        if (this.isOwner(player, location)) {
            this.locks.remove(location);
            player.sendMessage("Container unlocked.");
        } else {
            player.sendMessage("You are not the owner of this container.");
        }
    }

    public void trust(Player player, String trustedPlayerName) {
        OfflinePlayer trustedPlayer = Bukkit.getOfflinePlayer((String)trustedPlayerName);
        if (trustedPlayer != null && trustedPlayer.hasPlayedBefore()) {
            new HashSet<Lock>(this.locks.values()).stream().filter(lock -> lock.getOwner().equals(player.getUniqueId())).forEach(lock -> lock.addTrusted(trustedPlayer.getUniqueId()));
            player.sendMessage(trustedPlayerName + " has been trusted.");
        } else {
            player.sendMessage("Player not found.");
        }
    }

    public void untrust(Player player, String untrustedPlayerName) {
        OfflinePlayer untrustedPlayer = Bukkit.getOfflinePlayer((String)untrustedPlayerName);
        if (untrustedPlayer != null && untrustedPlayer.hasPlayedBefore()) {
            new HashSet<Lock>(this.locks.values()).stream().filter(lock -> lock.getOwner().equals(player.getUniqueId())).forEach(lock -> lock.removeTrusted(untrustedPlayer.getUniqueId()));
            player.sendMessage(untrustedPlayerName + " has been untrusted.");
        } else {
            player.sendMessage("Player not found.");
        }
    }

    public boolean isContainer(Block block) {
        return this.lockableBlocks.contains(block.getType().name()) && block.getState() instanceof Container;
    }

    public boolean isLocked(Location location) {
        return this.locks.containsKey(location);
    }

    public boolean isOwner(Player player, Location location) {
        return this.locks.containsKey(location) && this.locks.get(location).getOwner().equals(player.getUniqueId());
    }

    public boolean canAccess(Player player, Location location) {
        if (!this.isLocked(location)) {
            return true;
        }
        Lock lock = this.locks.get(location);
        if (lock.getOwner().equals(player.getUniqueId()) || lock.isTrusted(player.getUniqueId())) {
            return true;
        }
        for (String group : lock.getTrustedGroups()) {
            if (!player.hasPermission("chestlock999.group." + group)) continue;
            return true;
        }
        return false;
    }

    public void loadLocks() {
        File dataFile = new File(this.plugin.getDataFolder(), "locks.json");
        if (dataFile.exists()) {
            try (FileReader reader = new FileReader(dataFile);){
                LockData lockData = (LockData)this.gson.fromJson((Reader)reader, LockData.class);
                if (lockData != null && lockData.getLocks() != null) {
                    this.locks.putAll(lockData.getLocks());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveLocks() {
        File dataFile = new File(this.plugin.getDataFolder(), "locks.json");
        try (FileWriter writer = new FileWriter(dataFile);){
            this.gson.toJson((Object)new LockData(this.locks), (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Lock getLock(Location location) {
        return this.locks.get(location);
    }

    public boolean isNotifyOnAttemptedAccess() {
        return this.notifyOnAttemptedAccess;
    }

    public Map<Location, Lock> getAllLocks() {
        return new HashMap<Location, Lock>(this.locks);
    }

    public boolean isDefaultLockOnPlace() {
        return this.defaultLockOnPlace;
    }

    public void transferLock(Player player, Location location, UUID newOwnerUUID) {
        Lock lock;
        if (this.isOwner(player, location) && (lock = this.locks.get(location)) != null) {
            Lock newLock = new Lock(newOwnerUUID, lock.getCreationDate());
            for (UUID trustedPlayerUUID : lock.getTrusted()) {
                newLock.addTrusted(trustedPlayerUUID);
            }
            for (String trustedGroup : lock.getTrustedGroups()) {
                newLock.addTrustedGroup(trustedGroup);
            }
            this.locks.put(location, newLock);
        }
    }

    public void addTrustedGroup(Location location, String groupName) {
        Lock lock = this.locks.get(location);
        if (lock != null) {
            lock.addTrustedGroup(groupName);
        }
    }

    public void removeTrustedGroup(Location location, String groupName) {
        Lock lock = this.locks.get(location);
        if (lock != null) {
            lock.removeTrustedGroup(groupName);
        }
    }
}

