/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.LockManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LockTransferCommand
implements CommandExecutor {
    private final LockManager lockManager;

    public LockTransferCommand(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage("Usage: /locktransfer <player>");
            return true;
        }
        String targetPlayerName = args[0];
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)targetPlayerName);
        if (targetPlayer == null || !targetPlayer.hasPlayedBefore()) {
            player.sendMessage("Player '" + targetPlayerName + "' not found or has never played on this server.");
            return true;
        }
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock == null || !this.lockManager.isContainer(targetBlock)) {
            player.sendMessage("You must be looking at a lockable container.");
            return true;
        }
        if (!this.lockManager.isLocked(targetBlock.getLocation())) {
            player.sendMessage("This container is not locked.");
            return true;
        }
        if (!this.lockManager.isOwner(player, targetBlock.getLocation())) {
            player.sendMessage("You are not the owner of this locked container.");
            return true;
        }
        this.lockManager.transferLock(player, targetBlock.getLocation(), targetPlayer.getUniqueId());
        player.sendMessage("Ownership of the locked container transferred to " + targetPlayerName + ".");
        return true;
    }
}

