/*
 * Decompiled with CFR 0.152.
 */
package com.example.chestlock999;

import com.example.chestlock999.LockManager;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UntrustGroupCommand
implements CommandExecutor {
    private final LockManager lockManager;

    public UntrustGroupCommand(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage("Usage: /untrustgroup <groupname>");
            return true;
        }
        String groupName = args[0];
        Block targetBlock = player.getTargetBlockExact(5);
        if (targetBlock == null || !this.lockManager.isContainer(targetBlock)) {
            player.sendMessage("You must be looking at a lockable container.");
            return true;
        }
        if (!this.lockManager.isLocked(targetBlock.getLocation())) {
            player.sendMessage("This container is not locked.");
            return true;
        }
        if (!this.lockManager.isOwner(player, targetBlock.getLocation())) {
            player.sendMessage("You are not the owner of this locked container.");
            return true;
        }
        this.lockManager.removeTrustedGroup(targetBlock.getLocation(), groupName);
        player.sendMessage("Group '" + groupName + "' has been untrusted from this lock.");
        return true;
    }
}

