/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.compress.utils.Lists;
import vectorwing.farmersdelight.common.tag.ModTags;

public final class KrabbyPatty
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)3);
    private static final VoxelShape BOX_0 = KrabbyPatty.m_49796_((double)2.0, (double)0.0, (double)8.0, (double)8.0, (double)10.0, (double)14.0);
    private static final VoxelShape BOX_1 = KrabbyPatty.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)14.0, (double)10.0, (double)14.0);
    private static final VoxelShape BOX_2 = KrabbyPatty.m_49796_((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)8.0);
    private static final VoxelShape BOX_3 = KrabbyPatty.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)8.0, (double)10.0, (double)8.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{BOX_1, BOX_2, BOX_3};
    private final Supplier<Item> burger;
    private final Supplier<Item> mini_burger;

    public KrabbyPatty(Supplier<Item> burger, Supplier<Item> mini_burger) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50145_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
        this.burger = burger;
        this.mini_burger = mini_burger;
    }

    private static void onBiteOrCut(Level world, BlockState state, BlockPos pos) {
        int bites = (Integer)state.m_61143_((Property)BITES) + 1;
        if (bites > 3) {
            world.m_7471_(pos, false);
        }
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites)), 2);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level level = pContext.m_43725_();
        FluidState fluid = level.m_6425_(pContext.m_8083_());
        return (BlockState)super.m_5573_(pContext).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, BITES});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack holdItem = pPlayer.m_21120_(pHand);
        if (!holdItem.m_204117_(ModTags.KNIVES)) {
            pPlayer.m_5584_(pLevel, this.mini_burger.get().m_7968_());
            KrabbyPatty.onBiteOrCut(pLevel, pState, pPos);
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = new ItemStack((ItemLike)this.mini_burger.get());
        holdItem.m_41721_(holdItem.m_41773_() + 1);
        if (holdItem.m_41773_() > holdItem.m_41776_()) {
            stack.m_41774_(1);
            pPlayer.m_36246_(Stats.f_12983_.m_12902_((Object)holdItem.m_41720_()));
        }
        ItemEntity entity = new ItemEntity(pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_(), stack);
        entity.m_32060_();
        pLevel.m_7967_((Entity)entity);
        KrabbyPatty.onBiteOrCut(pLevel, pState, pPos);
        return InteractionResult.SUCCESS;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        ItemStack stack;
        boolean flag = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        if (!flag || player.m_7500_()) {
            return flag;
        }
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (!player.m_21120_(player.m_7655_()).m_204117_(ModTags.KNIVES) && bites == 0) {
            stack = this.burger.get().m_7968_();
        } else {
            stack = this.mini_burger.get().m_7968_();
            stack.m_41764_(4 - bites);
        }
        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
        entity.m_32060_();
        level.m_7967_((Entity)entity);
        return true;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Integer bites = (Integer)pState.m_61143_((Property)BITES);
        ArrayList arrayOf = Lists.newArrayList();
        for (int i = 0; i < 3 - bites; ++i) {
            arrayOf.add(SHAPES[i]);
        }
        return Shapes.m_83124_((VoxelShape)BOX_0, (VoxelShape[])arrayOf.toArray(new VoxelShape[0]));
    }

    public Item m_5456_() {
        return this.burger.get();
    }

    public ItemStack m_7397_(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return this.burger.get().m_7968_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.burger.get().m_7968_();
    }
}

