/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalBlockShape {
    protected final float length;
    protected final float width;
    protected final float height;
    protected final float center;
    protected final float space;
    protected final VoxelShape up;
    protected final VoxelShape down;
    protected final VoxelShape west;
    protected final VoxelShape east;
    protected final VoxelShape north;
    protected final VoxelShape south;

    public DirectionalBlockShape(float length, float width, float height) {
        this(length, width, height, 8.0f, 0.0f);
    }

    public DirectionalBlockShape(float length, float width, float height, float center, float space) {
        this.length = length;
        this.width = width;
        this.height = height;
        this.center = center;
        this.space = space;
        this.up = Block.box((double)(center - width / 2.0f), (double)space, (double)(center - length / 2.0f), (double)(center + width / 2.0f), (double)(height + space), (double)(center + length / 2.0f));
        this.down = Block.box((double)(center - width / 2.0f), (double)(16.0f - height - space), (double)(center - length / 2.0f), (double)(center + width / 2.0f), (double)(16.0f - space), (double)(center + length / 2.0f));
        this.west = Block.box((double)(16.0f - height - space), (double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)(16.0f - space), (double)(center + width / 2.0f), (double)(center + length / 2.0f));
        this.east = Block.box((double)space, (double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)(height + space), (double)(center + width / 2.0f), (double)(center + length / 2.0f));
        this.north = Block.box((double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)(16.0f - height - space), (double)(center + width / 2.0f), (double)(center + length / 2.0f), (double)(16.0f - space));
        this.south = Block.box((double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)(0.0f + space), (double)(center + width / 2.0f), (double)(center + length / 2.0f), (double)(height + space));
    }

    public VoxelShape getShape(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
            case Direction.WEST -> this.west;
            case Direction.EAST -> this.east;
            case Direction.NORTH -> this.north;
            case Direction.SOUTH -> this.south;
        };
    }

    public VoxelShape up() {
        return this.up;
    }

    public VoxelShape down() {
        return this.down;
    }

    public VoxelShape west() {
        return this.west;
    }

    public VoxelShape east() {
        return this.east;
    }

    public VoxelShape north() {
        return this.north;
    }

    public VoxelShape south() {
        return this.south;
    }
}

