/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.spirit;

import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class MinerSpiritItem
extends Item {
    private final Supplier<Integer> maxMiningTime;
    private final Supplier<Integer> rollsPerOperation;
    private final Supplier<Integer> maxDamage;
    private final int enchantmentValue;

    public MinerSpiritItem(Item.Properties properties, Supplier<Integer> maxMiningTime, Supplier<Integer> rollsPerOperation, Supplier<Integer> maxDamage) {
        super(properties.component(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY));
        this.maxMiningTime = maxMiningTime;
        this.rollsPerOperation = rollsPerOperation;
        this.maxDamage = maxDamage;
        this.enchantmentValue = 9;
    }

    public void onCraftedBy(ItemStack stack, Level worldIn, Player playerIn) {
        super.onCraftedBy(stack, worldIn, playerIn);
        stack.set(OccultismDataComponents.MAX_MINING_TIME, (Object)this.maxMiningTime.get());
        stack.set(OccultismDataComponents.ROLLS_PER_OPERATION, (Object)this.rollsPerOperation.get());
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
    }

    public int getMaxDamage(ItemStack stack) {
        return this.maxDamage.get();
    }

    public int getMaxStackSize(ItemStack stack) {
        if (!stack.has(OccultismDataComponents.MAX_MINING_TIME)) {
            stack.set(OccultismDataComponents.MAX_MINING_TIME, (Object)this.maxMiningTime.get());
        }
        if (!stack.has(OccultismDataComponents.ROLLS_PER_OPERATION)) {
            stack.set(OccultismDataComponents.ROLLS_PER_OPERATION, (Object)this.rollsPerOperation.get());
        }
        return super.getMaxStackSize(stack);
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }
}

