/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render.entity;

import com.klikli_dev.occultism.client.model.entity.ChimeraFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.ChimeraFamiliarEntity;
import com.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ChimeraFamiliarRenderer
extends MobRenderer<ChimeraFamiliarEntity, ChimeraFamiliarModel> {
    private static final ResourceLocation TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"textures/entity/chimera_familiar.png");

    public ChimeraFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ChimeraFamiliarModel(context.bakeLayer(OccultismModelLayers.FAMILIAR_CHIMERA)), 0.3f);
    }

    public void render(ChimeraFamiliarEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        if (pEntity.isSitting()) {
            pMatrixStack.translate(0.0, -0.14 * (double)pEntity.getScale(), 0.0);
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.popPose();
    }

    protected void scale(ChimeraFamiliarEntity livingEntity, PoseStack poseStack, float partialTickTime) {
        float size = livingEntity.getScale() * 0.5f;
        poseStack.scale(size, size, size);
    }

    public ResourceLocation getTextureLocation(ChimeraFamiliarEntity entity) {
        return TEXTURES;
    }
}

