/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class DepositItemsBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double DEPOSIT_ITEM_RANGE_SQUARE = Math.pow(2.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    public DepositItemsBehaviour() {
        this.runtimeProvider = entity -> 10;
    }

    protected boolean shouldKeepRunning(E entity) {
        return true;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        double dist = entity.distanceToSqr(Vec3.atCenterOf((Vec3i)depositPos));
        return StorageUtil.getFirstFilledSlot((IItemHandler)((SpiritEntity)entity).inventory) != -1 && dist <= DEPOSIT_ITEM_RANGE_SQUARE;
    }

    protected void start(E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        Direction depositFacing = (Direction)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_FACING.get());
        BlockEntity blockEntity = entity.level().getBlockEntity(depositPos);
        if (blockEntity != null) {
            int firstFilledSlot;
            ItemStackHandler entityItemHandler;
            ItemStack duplicate;
            ItemStack toInsert;
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(depositPos));
            IItemHandler depositItemHandler = (IItemHandler)entity.level().getCapability(Capabilities.ItemHandler.BLOCK, depositPos, blockEntity.getBlockState(), blockEntity, (Object)depositFacing);
            this.toggleContainer(blockEntity, true);
            if (depositItemHandler != null && (toInsert = ItemHandlerHelper.insertItem((IItemHandler)depositItemHandler, (ItemStack)(duplicate = (entityItemHandler = ((SpiritEntity)entity).inventory).getStackInSlot(firstFilledSlot = StorageUtil.getFirstFilledSlot((IItemHandler)entityItemHandler)).copy()), (boolean)true)).getCount() != duplicate.getCount()) {
                ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)depositItemHandler, (ItemStack)duplicate, (boolean)false);
                entityItemHandler.setStackInSlot(firstFilledSlot, leftover);
            }
        }
    }

    protected void stop(E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        BlockEntity blockEntity = entity.level().getBlockEntity(depositPos);
        if (blockEntity != null) {
            this.toggleContainer(blockEntity, false);
        }
    }

    public void toggleContainer(BlockEntity target, boolean open) {
        if (open) {
            target.getLevel().blockEvent(target.getBlockPos(), target.getBlockState().getBlock(), 1, 1);
        } else {
            target.getLevel().blockEvent(target.getBlockPos(), target.getBlockState().getBlock(), 1, 0);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

