package com.klikli_dev.occultism.datagen.book.pentacles;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookMultiblockPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.mojang.datafixers.util.Pair;
import net.minecraft.ChatFormatting;

public class SummonMaridEntry extends EntryProvider {

    public static final String ENTRY_ID = "summon_marid";


    public SummonMaridEntry(CategoryProvider parent) {
        super(parent);
    }

    @Override
    protected void generatePages() {

        this.page("intro", () -> BookTextPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
        );
        this.pageTitle("Fatmas Incentivized Attraction");
        this.pageText("""
                **Purpose:** Summon a {0}\\
                \\
                **Fatmas Incentivized Attraction** is a powerful pentacle, allowing you to summon and bind {1}
                 to your will.
                """,
                this.color("Marid", ChatFormatting.DARK_PURPLE),
                this.color("Marids", ChatFormatting.DARK_PURPLE)
        );

        this.page("multiblock", () -> BookMultiblockPageModel.create().withMultiblockId(this.modLoc(ENTRY_ID)));

        this.page("uses", () -> BookTextPageModel.create()
                .withTitle(this.context().pageTitle())
                .withText(this.context().pageText())
        );
        this.pageTitle("Uses");
        this.pageText("""
                - [Marid Crusher](entry://summoning_rituals/summon_crusher_t4)
                - [Marid Smelter](entry://summoning_rituals/summon_smelter_t4)
                - [Marid Crystallizer](entry://summoning_rituals/summon_crystallizer_t4)
                """
        );

    }

    @Override
    protected String entryName() {
        return "Fatma's Incentivized Attraction";
    }

    @Override
    protected String entryDescription() {
        return "Marid Summoning";
    }

    @Override
    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    @Override
    protected BookIconModel entryIcon() {
        return BookIconModel.create(OccultismItems.PENTACLE_SUMMON.get());
    }

    @Override
    protected String entryId() {
        return ENTRY_ID;
    }
}
