/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.storage;

import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.client.gui.storage.StorageControllerGuiBase;
import com.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateStorageSettings;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class StorageRemoteGui
extends StorageControllerGuiBase<StorageRemoteContainer> {
    protected StorageRemoteContainer container;

    public StorageRemoteGui(StorageRemoteContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.container = container;
    }

    @Override
    protected boolean isGuiValid() {
        return !this.container.getStorageRemote().isEmpty();
    }

    @Override
    protected BlockPos getEntityPosition() {
        return this.container.playerInventory.player.blockPosition();
    }

    @Override
    public SortDirection getSortDirection() {
        return (SortDirection)((Object)this.container.getStorageRemote().getOrDefault(OccultismDataComponents.SORT_DIRECTION, (Object)SortDirection.DOWN));
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.container.getStorageRemote().set(OccultismDataComponents.SORT_DIRECTION, (Object)sortDirection);
        Networking.sendToServer(new MessageUpdateStorageSettings(sortDirection, this.getSortType()));
    }

    @Override
    public SortType getSortType() {
        return (SortType)((Object)this.container.getStorageRemote().getOrDefault(OccultismDataComponents.SORT_TYPE, (Object)SortType.AMOUNT));
    }

    @Override
    public void setSortType(SortType sortType) {
        this.container.getStorageRemote().set(OccultismDataComponents.SORT_TYPE, (Object)sortType);
        Networking.sendToServer(new MessageUpdateStorageSettings(this.getSortDirection(), sortType));
    }
}

