/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.behaviour.HarvestCropBehaviour;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSelectBlock;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToCropBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final int FORGET_UNREACHABLE_CROPS_AFTER_TICKS = 6000;
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.LAST_CROP_WALK_TARGET.get(), (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.NEAREST_CROP.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.UNREACHABLE_CROPS.get(), (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), (Object)MemoryStatus.REGISTERED)});

    protected void start(E entity) {
        BlockPos cropPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
        if (entity.distanceToSqr(Vec3.atCenterOf((Vec3i)cropPos)) < HarvestCropBehaviour.HARVEST_CROP_RANGE_SQUARE) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
            BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_CROP_WALK_TARGET.get());
        } else {
            BlockPos walkPos = null;
            Set unreachableWalkTargets = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), HashSet::new);
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos pos = cropPos.relative(facing);
                if (!entity.level().isEmptyBlock(pos) || unreachableWalkTargets.contains(pos)) continue;
                walkPos = pos;
                break;
            }
            if (walkPos != null) {
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(walkPos));
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(walkPos, 1.0f, 1));
                BrainUtils.setMemory(entity, OccultismMemoryTypes.LAST_CROP_WALK_TARGET.get(), (Object)new WalkTarget(walkPos, 1.0f, 1));
                if (Occultism.DEBUG.debugAI) {
                    Networking.sendToTracking(entity, new MessageSelectBlock(cropPos, 1000, 0xFF00FF));
                    Networking.sendToTracking(entity, new MessageSelectBlock(walkPos, 1000, 65280));
                }
            } else {
                Set unreachableCrops = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_CROPS.get(), HashSet::new);
                unreachableCrops.add(cropPos);
                BrainUtils.setForgettableMemory(entity, OccultismMemoryTypes.UNREACHABLE_CROPS.get(), (Object)unreachableCrops, (int)6000);
                BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
                BrainUtils.clearMemory(entity, OccultismMemoryTypes.LAST_CROP_WALK_TARGET.get());
                BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_CROP.get());
                if (Occultism.DEBUG.debugAI) {
                    Networking.sendToTracking(entity, new MessageSelectBlock(cropPos, 10000, 0xFF0000));
                }
            }
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

