/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl;

import com.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageSetRecipe;
import com.klikli_dev.occultism.network.messages.MessageSetRecipeByID;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class StorageControllerRecipeTransferHandler<T extends AbstractContainerMenu>
implements IRecipeTransferHandler<T, RecipeHolder<CraftingRecipe>> {
    protected final Class<T> containerClass;
    protected final IRecipeTransferHandlerHelper handlerHelper;

    public StorageControllerRecipeTransferHandler(Class<T> containerClass, IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
        this.containerClass = containerClass;
    }

    public CompoundTag recipeToNbt(AbstractContainerMenu container, IRecipeSlotsView recipeSlots) {
        CompoundTag nbt = new CompoundTag();
        List slotsViewList = recipeSlots.getSlotViews();
        for (Slot slot : container.slots) {
            List possibleItems;
            IRecipeSlotView slotView;
            if (!(slot.container instanceof CraftingContainer) || (slotView = (IRecipeSlotView)slotsViewList.get(slot.getSlotIndex() + 1)) == null || (possibleItems = slotView.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).collect(Collectors.toList())).isEmpty()) continue;
            ListTag invList = new ListTag();
            for (int i = 0; i < possibleItems.size() && i < 5; ++i) {
                ItemStack itemStack = (ItemStack)possibleItems.get(i);
                if (itemStack.isEmpty()) continue;
                invList.add((Object)itemStack.saveOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
            }
            nbt.put("s" + slot.getSlotIndex(), (Tag)invList);
        }
        return nbt;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    public IRecipeTransferError transferRecipe(T container, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (recipe.id() == null) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.occultismerror.missing_id"));
        }
        if (!((CraftingRecipe)recipe.value()).canCraftInDimensions(3, 3)) {
            return this.handlerHelper.createUserErrorWithTooltip((Component)Component.translatable((String)"jei.occultismerror.recipe_too_large"));
        }
        if (container instanceof StorageControllerContainerBase) {
            StorageControllerContainerBase menu = (StorageControllerContainerBase)container;
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList inputs = new ArrayList();
            Object2IntOpenHashMap reservedGridAmounts = new Object2IntOpenHashMap();
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                List possibleStacks = view.getItemStacks().toList();
                if (possibleStacks.isEmpty()) {
                    inputs.add(List.of());
                    continue;
                }
                inputs.add(possibleStacks);
                boolean found = false;
                for (ItemStack stack : possibleStacks) {
                    if (stack == null || player.getInventory().findSlotMatchingItem(stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ItemStack stack : possibleStacks) {
                        if (!menu.hasIngredient(Ingredient.of((ItemStack[])new ItemStack[]{stack}), (Object2IntOpenHashMap<Object>)reservedGridAmounts)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer) {
                if (player.getCommandSenderWorld().getRecipeManager().byKey(recipe.id()).isPresent()) {
                    Networking.sendToServer(new MessageSetRecipeByID(recipe.id()));
                } else {
                    Networking.sendToServer(new MessageSetRecipe(this.recipeToNbt((AbstractContainerMenu)container, recipeSlots)));
                }
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.handlerHelper.createUserErrorForMissingSlots((Component)Component.translatable((String)"jei.occultism.error.recipe_no_items"), missing));
            }
        }
        return null;
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        @NotNull
        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(@NotNull GuiGraphics matrixStack, int mouseX, int mouseY, @NotNull IRecipeSlotsView recipeLayout, int recipeX, int recipeY) {
            this.parent.showError(matrixStack, mouseX, mouseY, recipeLayout, recipeX, recipeY);
        }
    }
}

