/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.network.MessageSelectBlock;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.item.ItemEntity;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToItemBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26332_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected void start(E entity) {
        ItemEntity jobItem = (ItemEntity)BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
        if (jobItem != null && jobItem.m_6084_()) {
            if (Math3DUtil.withinAxisDistances(entity.m_20182_(), jobItem.m_20182_(), 2.5, 16.0, 2.5)) {
                BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
            } else {
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)jobItem, false));
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget((Entity)jobItem, 1.0f, 0));
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(jobItem.m_20183_(), 5000, 65280));
                }
            }
        } else {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26332_);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

