/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.item.custom;

import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CapsuleConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "legendaries.json";
    private static List<String> legendaryPokemon = new ArrayList<String>();
    private static final List<String> DEFAULT_LEGENDARY_POKEMON = Arrays.asList("arceus", "articuno", "azelf", "calyrex", "celebi", "chienpao", "chiyu", "cobalion", "cosmoem", "cosmog", "cresselia", "darkrai", "deoxys", "dialga", "diancie", "enamorus", "entei", "eternatus", "fezandipiti", "genesect", "giratina", "glastrier", "groudon", "heatran", "hooh", "hoopa", "jirachi", "keldeo", "koraidon", "kubfu", "kyogre", "kyurem", "landorus", "latias", "latios", "lugia", "lunala", "magearna", "manaphy", "marshadow", "melmetal", "meloetta", "meltan", "mesprit", "mew", "mewtwo", "miraidon", "moltres", "munkidori", "necrozma", "ogerpon", "okidogi", "palkia", "pecharunt", "phione", "raikou", "rayquaza", "regice", "regidrago", "regieleki", "regigigas", "regirock", "registeel", "reshiram", "rnadus", "shaymin", "silvally", "solgaleo", "spectrier", "suicune", "tapubulu", "tapufini", "tapukoko", "tapulele", "terapagos", "terrakion", "thundurus", "tinglu", "ultranecrozma", "urshifu", "uxie", "victini", "virizion", "volcanion", "wochien", "xerneas", "yveltal", "zacian", "zamazenta", "zapdos", "zarude", "zekrom", "zeraora", "zygarde");

    public static void loadConfig(Path configDir) {
        File configFile;
        File modConfigDir = configDir.resolve("cobble-gacha-machine").toFile();
        if (!modConfigDir.exists()) {
            modConfigDir.mkdirs();
        }
        if (!(configFile = modConfigDir.toPath().resolve(CONFIG_FILE_NAME).toFile()).exists()) {
            CapsuleConfig.createDefaultConfig(configFile);
            legendaryPokemon = new ArrayList<String>(DEFAULT_LEGENDARY_POKEMON);
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (json.has("legendary_pokemon")) {
                JsonArray array = json.getAsJsonArray("legendary_pokemon");
                legendaryPokemon.clear();
                array.forEach(element -> legendaryPokemon.add(element.getAsString()));
            } else {
                legendaryPokemon = new ArrayList<String>(DEFAULT_LEGENDARY_POKEMON);
            }
        }
        catch (Exception e) {
            CobbleGachaMachine.LOGGER.warn("Error al cargar la configuraci\u00f3n de c\u00e1psulas, usando valores por defecto.");
            e.printStackTrace();
            legendaryPokemon = new ArrayList<String>(DEFAULT_LEGENDARY_POKEMON);
        }
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            JsonObject json = new JsonObject();
            json.addProperty("_comment", "Lista de Pok\u00e9mon disponibles en las c\u00e1psulas legendarias. Puedes agregar o quitar Pok\u00e9mon seg\u00fan lo desees.");
            JsonArray pokemonArray = new JsonArray();
            for (String pokemon : DEFAULT_LEGENDARY_POKEMON) {
                pokemonArray.add(pokemon);
            }
            json.add("legendary_pokemon", (JsonElement)pokemonArray);
            try (FileWriter writer = new FileWriter(configFile);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Error al crear el archivo de configuraci\u00f3n por defecto.");
            e.printStackTrace();
        }
    }

    public static List<String> getLegendaryPokemon() {
        return new ArrayList<String>(legendaryPokemon);
    }

    public static void reloadConfig(Path configDir) {
        CapsuleConfig.loadConfig(configDir);
    }
}

