/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.item.custom;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.cristoh.cobblegachamachine.item.custom.CapsuleConfig;
import com.cristoh.cobblegachamachine.item.custom.CapsuleRarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_5819;

public class PokemonSelector {
    public static Pokemon selectPokemonByRarity(class_3218 world, class_1657 player, CapsuleRarity rarity) {
        List<WeightedSpecies> eligibleSpecies = PokemonSelector.getEligibleSpeciesFromSpawnPools(rarity);
        eligibleSpecies = rarity.useCustomList() ? PokemonSelector.getCustomListSpecies(rarity) : PokemonSelector.getEligibleSpeciesFromSpawnPools(rarity);
        if (eligibleSpecies.isEmpty()) {
            CobbleGachaMachine.LOGGER.warn("No se encontraron especies elegibles para la rareza: " + rarity.getName());
            return null;
        }
        Species selectedSpecies = rarity.useCustomList() ? eligibleSpecies.get((int)world.field_9229.method_43048((int)eligibleSpecies.size())).species : PokemonSelector.selectSpeciesByWeight(eligibleSpecies, world.field_9229);
        int level = rarity.getMinLevel() + world.field_9229.method_43048(rarity.getMaxLevel() - rarity.getMinLevel() + 1);
        Pokemon pokemon = selectedSpecies.create(level);
        if (rarity == CapsuleRarity.ULTRA_RARE && world.field_9229.method_43048(512) == 0) {
            pokemon.setShiny(true);
        } else if (rarity == CapsuleRarity.RARE && world.field_9229.method_43048(1024) == 0) {
            pokemon.setShiny(true);
        } else if (rarity == CapsuleRarity.LEGENDARY && world.field_9229.method_43048(256) == 0) {
            pokemon.setShiny(true);
        }
        return pokemon;
    }

    private static List<WeightedSpecies> getCustomListSpecies(CapsuleRarity rarity) {
        ArrayList<WeightedSpecies> customSpecies = new ArrayList<WeightedSpecies>();
        List<String> pokemonNames = CapsuleConfig.getLegendaryPokemon();
        for (String pokemonName : pokemonNames) {
            try {
                Species species = PokemonSpecies.INSTANCE.getByName(pokemonName);
                if (species != null) {
                    customSpecies.add(new WeightedSpecies(species, 1.0f));
                    continue;
                }
                CobbleGachaMachine.LOGGER.info("Pok\u00e9mon no encontrado desde la config: " + pokemonName);
            }
            catch (Exception e) {
                CobbleGachaMachine.LOGGER.error("Error al cargar Pok\u00e9mon desde la config: " + pokemonName);
            }
        }
        return customSpecies;
    }

    private static List<WeightedSpecies> getEligibleSpeciesFromSpawnPools(CapsuleRarity rarity) {
        HashMap<String, WeightedSpecies> uniqueSpecies = new HashMap<String, WeightedSpecies>();
        String[] allowedBuckets = rarity.getAllowedBuckets();
        float minWeight = rarity.getMinWeight();
        float maxWeight = rarity.getMaxWeight();
        SpawnPool spawnPool = CobblemonSpawnPools.INSTANCE.getWORLD_SPAWN_POOL();
        for (SpawnDetail spawnDetail : spawnPool.getDetails()) {
            try {
                String pokemonName;
                Species species;
                float weight;
                String bucketName = spawnDetail.getBucket().getName();
                boolean isBucketAllowed = false;
                for (String allowedBucket : allowedBuckets) {
                    if (!bucketName.equalsIgnoreCase(allowedBucket)) continue;
                    isBucketAllowed = true;
                    break;
                }
                if (!isBucketAllowed || !((weight = spawnDetail.getWeight()) >= minWeight) || !(weight <= maxWeight) || !(spawnDetail instanceof PokemonSpawnDetail) || (species = PokemonSpecies.INSTANCE.getByName(pokemonName = ((PokemonSpawnDetail)spawnDetail).getPokemon().getSpecies())) == null) continue;
                if (!uniqueSpecies.containsKey(pokemonName)) {
                    uniqueSpecies.put(pokemonName, new WeightedSpecies(species, weight));
                    continue;
                }
                WeightedSpecies existing = (WeightedSpecies)uniqueSpecies.get(pokemonName);
                if (!(weight > existing.weight)) continue;
                uniqueSpecies.put(pokemonName, new WeightedSpecies(species, weight));
            }
            catch (Exception e) {}
        }
        return new ArrayList<WeightedSpecies>(uniqueSpecies.values());
    }

    private static Species selectSpeciesByWeight(List<WeightedSpecies> weightedSpecies, class_5819 random) {
        float totalWeight = 0.0f;
        for (WeightedSpecies ws : weightedSpecies) {
            totalWeight += ws.weight;
        }
        if (totalWeight == 0.0f) {
            return weightedSpecies.get((int)random.method_43048((int)weightedSpecies.size())).species;
        }
        float randomValue = random.method_43057() * totalWeight;
        float currentWeight = 0.0f;
        for (WeightedSpecies ws : weightedSpecies) {
            if (!(randomValue < (currentWeight += ws.weight))) continue;
            return ws.species;
        }
        return weightedSpecies.get((int)random.method_43048((int)weightedSpecies.size())).species;
    }

    private static class WeightedSpecies {
        Species species;
        float weight;

        WeightedSpecies(Species species, float weight) {
            this.species = species;
            this.weight = weight;
        }
    }
}

