/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.block.entity.custom;

import com.cristoh.cobblegachamachine.ModTags;
import com.cristoh.cobblegachamachine.block.entity.ImplementedInventory;
import com.cristoh.cobblegachamachine.block.entity.ModBlockEntities;
import com.cristoh.cobblegachamachine.item.ModItems;
import com.cristoh.cobblegachamachine.screen.custom.GachaScreenHandler;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class GachaBlockEntity
extends class_2586
implements ImplementedInventory,
ExtendedScreenHandlerFactory<class_2338> {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)7, (Object)class_1799.field_8037);
    private static final int POOL_SIZE = 15;
    private final class_2371<class_1799> pool = class_2371.method_10213((int)15, (Object)class_1799.field_8037);
    private int windowStart = 0;
    private int totalShifts = 0;
    private int shiftsRemaining = 0;
    private int clearDelayTicks = 0;
    private int totalSpinTicks = 0;
    private int spinTicksRemaining = 0;
    private int tickAccumulator = 0;
    private boolean spinning = false;
    private UUID requester = null;
    private final Random random = new Random();
    private static final class_1792[] CAPSULE_TYPES = new class_1792[]{ModItems.NORMAL_CAPSULE, ModItems.RARE_CAPSULE, ModItems.ULTRA_RARE_CAPSULE, ModItems.LEGENDARY_CAPSULE};
    private static final int[] CAPSULE_WEIGHTS = new int[]{70, 25, 5, 2};

    public GachaBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.GACHA_BLOCK_ENTITY, pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_1799 getCoinStack() {
        return (class_1799)this.inventory.getFirst();
    }

    public void setCoinStack(class_1799 stack) {
        this.inventory.set(0, (Object)stack);
        this.method_5431();
    }

    private class_1799 pickWeightedCapsule() {
        int total = 0;
        for (int w : CAPSULE_WEIGHTS) {
            total += w;
        }
        int r = this.random.nextInt(total);
        int acc = 0;
        for (int i = 0; i < CAPSULE_TYPES.length; ++i) {
            if (r >= (acc += CAPSULE_WEIGHTS[i])) continue;
            return CAPSULE_TYPES[i].method_7854();
        }
        return CAPSULE_TYPES[0].method_7854();
    }

    public boolean startSpinIfHasCoin(class_3222 player) {
        if (this.spinning) {
            return false;
        }
        class_1799 coin = this.getCoinStack();
        if (coin.method_31573(ModTags.Items.COIN_ITEMS)) {
            this.field_11863.method_8396(null, this.field_11867, ModSounds.GACHA_DIAL, class_3419.field_15245, 1.0f, 1.0f);
            coin.method_7934(1);
            if (coin.method_7960()) {
                this.inventory.set(0, (Object)class_1799.field_8037);
            }
            for (int i = 0; i < 15; ++i) {
                this.pool.set(i, (Object)this.pickWeightedCapsule());
            }
            this.windowStart = this.random.nextInt(15);
            this.updateVisibleFromPool();
            int targetIndex = this.random.nextInt(15);
            int desiredWindowStart = (targetIndex - 2 + 15) % 15;
            int cycles = 2 + this.random.nextInt(3);
            this.shiftsRemaining = this.totalShifts = cycles * 15 + (desiredWindowStart - this.windowStart + 15) % 15;
            this.tickAccumulator = 0;
            this.spinning = true;
            this.requester = player.method_5667();
            this.method_5431();
            return true;
        }
        return false;
    }

    private void updateVisibleFromPool() {
        for (int i = 0; i < 5; ++i) {
            class_1799 item = (class_1799)this.pool.get((this.windowStart + i) % 15);
            this.inventory.set(1 + i, (Object)(item == null ? class_1799.field_8037 : item.method_7972()));
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, GachaBlockEntity be) {
        if (world.method_8608()) {
            return;
        }
        be.serverTick();
    }

    private void serverTick() {
        if (this.clearDelayTicks > 0) {
            --this.clearDelayTicks;
            if (this.clearDelayTicks == 0) {
                for (int i = 1; i <= 5; ++i) {
                    this.inventory.set(i, (Object)class_1799.field_8037);
                }
                this.method_5431();
            }
        }
        if (!this.spinning) {
            return;
        }
        if (this.requester == null) {
            return;
        }
        if (this.field_11863 == null || this.field_11863.method_8503() == null) {
            return;
        }
        class_3222 player = this.field_11863.method_8503().method_3760().method_14602(this.requester);
        ++this.tickAccumulator;
        if (this.totalShifts <= 0) {
            this.totalShifts = 1;
        }
        double progress = 1.0 - (double)this.shiftsRemaining / (double)this.totalShifts;
        double ease = progress * progress;
        int minInterval = 2;
        int maxInterval = 12;
        int interval = 2 + (int)Math.round(10.0 * ease);
        if (interval < 1) {
            interval = 1;
        }
        if (this.tickAccumulator >= interval) {
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_26982, class_3419.field_15245, 1.0f, 1.0f);
            this.windowStart = (this.windowStart + 1) % 15;
            this.updateVisibleFromPool();
            --this.shiftsRemaining;
            this.tickAccumulator = 0;
            this.method_5431();
        }
        if (this.shiftsRemaining <= 0) {
            this.spinning = false;
            this.field_11863.method_8396(null, this.field_11867, ModSounds.GACHA_DISPENSE, class_3419.field_15245, 1.0f, 1.0f);
            if (player != null) {
                class_1799 rewardCapsule = ((class_1799)this.inventory.get(3)).method_7972();
                if (!player.method_31548().method_7394(rewardCapsule)) {
                    player.method_7328(rewardCapsule, false);
                }
                this.clearDelayTicks = 25;
            }
            this.requester = null;
            this.method_5431();
        }
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11014(tag, registryLookup);
        this.totalSpinTicks = tag.method_10550("TotalSpinTicks");
        this.spinTicksRemaining = tag.method_10550("SpinTicksRemaining");
        this.tickAccumulator = tag.method_10550("TickAccumulator");
        this.spinning = tag.method_10577("Spinning");
        if (tag.method_25928("Requester")) {
            this.requester = tag.method_25926("Requester");
        }
        class_1262.method_5429((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registryLookup) {
        super.method_11007(tag, registryLookup);
        tag.method_10569("TotalSpinTicks", this.totalSpinTicks);
        tag.method_10569("SpinTicksRemaining", this.spinTicksRemaining);
        tag.method_10569("TickAccumulator", this.tickAccumulator);
        tag.method_10556("Spinning", this.spinning);
        if (this.requester != null) {
            tag.method_25927("Requester", this.requester);
        }
        class_1262.method_5426((class_2487)tag, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.cobble-gacha-machine.gacha_block");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new GachaScreenHandler(syncId, playerInventory, this.field_11867);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

