/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.item.custom;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.cristoh.cobblegachamachine.ModLootTables;
import com.cristoh.cobblegachamachine.item.custom.CapsuleRarity;
import com.cristoh.cobblegachamachine.item.custom.PokemonHandler;
import com.cristoh.cobblegachamachine.item.custom.PokemonSelector;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;

public class CapsuleItem
extends class_1792 {
    private final CapsuleRarity rarity;
    private class_2960 lootTableId;

    public CapsuleItem(class_1792.class_1793 settings, CapsuleRarity rarity) {
        super(settings);
        this.rarity = rarity;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return class_1271.method_22428((Object)user.method_5998(hand));
        }
        class_1799 capsule = user.method_5998(hand);
        boolean pokemonSpawned = this.spawnPokemonIfNeeded((class_3218)world, user);
        if (pokemonSpawned) {
            this.playEffects(world, user);
        } else {
            List<class_1799> drops = this.getDrops((class_3218)world, user.method_19538(), (class_1297)user);
            for (class_1799 stack : drops) {
                if (user.method_7270(stack)) continue;
                user.method_7328(stack, false);
            }
            world.method_8396(null, user.method_24515(), ModSounds.CAPSULE_OPEN, class_3419.field_15248, 1.0f, 1.0f);
        }
        class_1799 resultStack = capsule.method_7972();
        resultStack.method_7934(1);
        return class_1271.method_22427((Object)resultStack);
    }

    private List<class_1799> getDrops(class_3218 world, class_243 pos, class_1297 user) {
        if (this.getLootTableId() == null) {
            return Collections.emptyList();
        }
        class_8567 lootContextParameterSet = new class_8567.class_8568(world).method_51874(class_181.field_24424, (Object)pos).method_51877(class_181.field_1226, (Object)user).method_51875(ModLootTables.CAPSULE);
        class_52 lootTable = world.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)this.getLootTableId()));
        ObjectArrayList result = lootTable.method_51878(lootContextParameterSet);
        return result;
    }

    private boolean spawnPokemonIfNeeded(class_3218 world, class_1657 player) {
        double pokemonChance = this.rarity.getPokemonSpawnChance();
        if (world.field_9229.method_43058() < pokemonChance) {
            this.spawnPokemon(world, player);
            return true;
        }
        return false;
    }

    private void spawnPokemon(class_3218 world, class_1657 player) {
        try {
            Pokemon pokemon = PokemonSelector.selectPokemonByRarity(world, player, this.rarity);
            if (pokemon != null) {
                PokemonHandler.addPokemonToPlayer(player, pokemon);
                player.method_7353((class_2561)class_2561.method_43469((String)"text.cobble-gacha-machine.pokemon_obtained", (Object[])new Object[]{this.rarity.getChatPrefix(), pokemon.getSpecies().getName()}), false);
            }
        }
        catch (Exception e) {
            CobbleGachaMachine.LOGGER.error("Error al spawnear Pok\u00e9mon: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void playEffects(class_1937 world, class_1657 player) {
        class_3414 sound = this.rarity.getSound();
        world.method_8396(null, player.method_24515(), sound, class_3419.field_15248, 1.0f, 1.0f);
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_14199(this.rarity.getParticle(), player.method_23317(), player.method_23318() + 1.0, player.method_23321(), this.rarity.getParticleCount(), 0.5, 0.5, 0.5, 0.1);
        }
    }

    public final class_2960 getLootTableId() {
        if (this.lootTableId == null) {
            this.lootTableId = class_7923.field_41178.method_10221((Object)this).method_45138("capsules/");
        }
        return this.lootTableId;
    }

    public CapsuleRarity getRarity() {
        return this.rarity;
    }
}

