/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.color;

import de.tomalbrc.cameraobscura.util.RPHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_10829;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2457;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5742;
import net.minecraft.class_6880;

public class BlockColors {
    private static BufferedImage GRASS_TEXTURE;
    private static BufferedImage FOLIAGE_TEXTURE;
    private static BufferedImage DRY_FOLIAGE_TEXTURE;
    private static final Map<class_2248, BlockColorProvider> colors;

    private static void loadColorMaps() {
        try {
            GRASS_TEXTURE = ImageIO.read(RPHelper.getTexture(class_2960.method_60656((String)"colormap/grass")));
            FOLIAGE_TEXTURE = ImageIO.read(RPHelper.getTexture(class_2960.method_60656((String)"colormap/foliage")));
            DRY_FOLIAGE_TEXTURE = ImageIO.read(RPHelper.getTexture(class_2960.method_60656((String)"colormap/dry_foliage")));
            class_1933.method_8376((int[])GRASS_TEXTURE.getRGB(0, 0, GRASS_TEXTURE.getWidth(), GRASS_TEXTURE.getHeight(), null, 0, GRASS_TEXTURE.getWidth()));
            class_1926.method_8340((int[])FOLIAGE_TEXTURE.getRGB(0, 0, FOLIAGE_TEXTURE.getWidth(), FOLIAGE_TEXTURE.getHeight(), null, 0, FOLIAGE_TEXTURE.getWidth()));
            class_10829.method_68144((int[])DRY_FOLIAGE_TEXTURE.getRGB(0, 0, DRY_FOLIAGE_TEXTURE.getWidth(), DRY_FOLIAGE_TEXTURE.getHeight(), null, 0, DRY_FOLIAGE_TEXTURE.getWidth()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void init() {
        BlockColors.loadColorMaps();
        BlockColorProvider grassColor = (level, blockState, blockPos) -> ((class_1959)BlockColors.getBiome(level, blockPos).comp_349()).method_8711((double)blockPos.method_10263(), (double)blockPos.method_10260());
        BlockColorProvider foliageColor = (level, blockState, blockPos) -> ((class_1959)BlockColors.getBiome(level, blockPos).comp_349()).method_8698();
        BlockColorProvider dryFoliageColor = (level, blockState, blockPos) -> ((class_1959)BlockColors.getBiome(level, blockPos).comp_349()).method_68145();
        colors.put(class_2246.field_10313, grassColor);
        colors.put(class_2246.field_56562, dryFoliageColor);
        colors.put(class_2246.field_56563, dryFoliageColor);
        colors.put(class_2246.field_55742, dryFoliageColor);
        colors.put(class_2246.field_10424, foliageColor);
        colors.put(class_2246.field_10219, grassColor);
        colors.put(class_2246.field_56454, grassColor);
        colors.put(class_2246.field_10112, grassColor);
        colors.put(class_2246.field_10479, grassColor);
        colors.put(class_2246.field_10214, grassColor);
        colors.put(class_2246.field_10128, grassColor);
        colors.put(class_2246.field_42750, grassColor);
        colors.put(class_2246.field_9988, (level, blockState, blockPos) -> -10380959);
        colors.put(class_2246.field_10539, (level, blockState, blockPos) -> -8345771);
        colors.put(class_2246.field_10503, foliageColor);
        colors.put(class_2246.field_10335, foliageColor);
        colors.put(class_2246.field_10098, foliageColor);
        colors.put(class_2246.field_10035, foliageColor);
        colors.put(class_2246.field_10597, foliageColor);
        colors.put(class_2246.field_37551, foliageColor);
        colors.put(class_2246.field_10091, (level, blockState, blockPos) -> class_2457.method_10487((int)((Integer)blockState.method_11654((class_2769)class_2457.field_11432))));
        colors.put(class_2246.field_46285, (level, blockState, blockPos) -> 14731036);
        colors.put(class_2246.field_46284, (level, blockState, blockPos) -> 14731036);
        colors.put(class_2246.field_46287, (level, blockState, blockPos) -> {
            int j = (Integer)blockState.method_11654((class_2769)class_2513.field_11584);
            int k = j * 32;
            int l = 255 - j * 8;
            int m = j * 4;
            return k << 16 | l << 8 | m;
        });
        colors.put(class_2246.field_46286, (level, blockState, blockPos) -> {
            int j = (Integer)blockState.method_11654((class_2769)class_2513.field_11584);
            int k = j * 32;
            int l = 255 - j * 8;
            int m = j * 4;
            return k << 16 | l << 8 | m;
        });
        colors.put(class_2246.field_10588, (level, blockState, blockPos) -> 2129968);
    }

    public static int get(class_2818 level, class_2680 blockState, class_2338 blockPos) {
        BlockColorProvider colorProvider = colors.get(blockState.method_26204());
        if (colorProvider != null) {
            return colorProvider.get(level, blockState, blockPos) | 0xFF000000;
        }
        return -1;
    }

    public static int biomeWaterColor(class_2818 level, class_2338 blockPos) {
        return 0xFF000000 | ((class_1959)BlockColors.getBiome(level, blockPos).comp_349()).method_8687();
    }

    private static class_6880<class_1959> getBiome(class_2818 chunk, class_2338 blockPos) {
        return chunk.method_16359(class_5742.method_33100((int)blockPos.method_10263()), class_5742.method_33100((int)blockPos.method_10264()), class_5742.method_33100((int)blockPos.method_10260()));
    }

    static {
        colors = new IdentityHashMap<class_2248, BlockColorProvider>();
    }

    static interface BlockColorProvider {
        public int get(class_2818 var1, class_2680 var2, class_2338 var3);
    }
}

