/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.render.model.resource.state.Variant;
import java.lang.reflect.Type;

public class VariantDeserializer
implements JsonDeserializer<Variant> {
    public Variant deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            Variant variant = new Variant();
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("model")) {
                variant.model = CachedResourceLocationDeserializer.get(jsonObject.get("model").getAsString());
            }
            if (jsonObject.has("uvlock")) {
                variant.uvlock = jsonObject.get("uvlock").getAsBoolean();
            }
            if (jsonObject.has("x")) {
                variant.x = jsonObject.get("x").getAsInt();
            }
            if (jsonObject.has("y")) {
                variant.y = jsonObject.get("y").getAsInt();
            }
            if (jsonObject.has("z")) {
                variant.z = jsonObject.get("z").getAsInt();
            }
            return variant;
        }
        if (json.isJsonArray()) {
            JsonArray jsonArray = json.getAsJsonArray();
            if (jsonArray.size() > 0) {
                return (Variant)context.deserialize(jsonArray.get(0), Variant.class);
            }
            return null;
        }
        throw new JsonParseException("Unexpected JSON element type for Variant: " + String.valueOf(json));
    }
}

