/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render;

import de.tomalbrc.cameraobscura.color.BlockColors;
import de.tomalbrc.cameraobscura.color.MiscColors;
import de.tomalbrc.cameraobscura.render.model.RenderModel;
import de.tomalbrc.cameraobscura.render.model.resource.RPModel;
import de.tomalbrc.cameraobscura.render.model.triangle.TriangleModel;
import de.tomalbrc.cameraobscura.util.BuiltinEntityModels;
import de.tomalbrc.cameraobscura.util.BuiltinModels;
import de.tomalbrc.cameraobscura.util.ColorHelper;
import de.tomalbrc.cameraobscura.util.RPHelper;
import de.tomalbrc.cameraobscura.world.BlockIterator;
import de.tomalbrc.cameraobscura.world.EntityIterator;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.nem.block.ModBlocks;
import me.drex.nem.config.ModConfig;
import net.minecraft.class_1309;
import net.minecraft.class_1944;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_9848;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Raytracer {
    private static final Vector3f SUN = new Vector3f(1.0f, 2.0f, 1.0f).normalize();
    private final class_3218 level;
    private static final Map<class_2680, List<TriangleModel>> renderModelCache = new Reference2ObjectArrayMap();
    private static final Int2ObjectArrayMap<RenderModel> fluidRenderModelCache = new Int2ObjectArrayMap();
    private final BlockIterator blockIterator;
    private final EntityIterator entityIterator;
    private final int distance;
    private final int skyDarken;
    private static final TriangleModel localSkyModel = new TriangleModel(BuiltinModels.skyModel(class_243.field_1353));

    public Raytracer(class_1309 entity, int distance) {
        this.level = (class_3218)entity.method_73183();
        this.distance = distance;
        this.blockIterator = new BlockIterator(this.level, entity, distance);
        this.entityIterator = new EntityIterator(this.level, entity);
        this.skyDarken = this.level.method_8594();
    }

    public int trace(class_243 pos, class_243 direction) {
        int color = this.traceSingle(pos, direction);
        if ((color >> 24 & 0xFF) < 255) {
            int skyColor = this.level.method_8597().comp_642() ? this.skyColorWithClouds(pos, direction) : -15724528;
            color = ColorHelper.alphaComposite(color, skyColor);
        }
        return color;
    }

    private int traceSingle(class_243 pos, class_243 direction) {
        class_243 scaledDir = new class_243(direction.field_1352, direction.field_1351, direction.field_1350).method_1021((double)this.distance).method_1019(pos);
        class_3959 context = new class_3959(pos, scaledDir, null, class_3959.class_242.field_1347, class_3726.method_16194());
        List<BlockIterator.WorldHit> result = this.blockIterator.raycast(context);
        List<EntityIterator.EntityHit> entityResult = this.entityIterator.raycast(context);
        int color = 0xFFFFFF;
        boolean hasHitWater = false;
        for (int i = 0; i < result.size(); ++i) {
            boolean transparent;
            boolean isWater = result.get(i).isWaterOrWaterlogged();
            boolean bl = transparent = (color >> 24 & 0xFF) == 0;
            if (hasHitWater && !transparent && result.get(i).blockState().method_27852(class_2246.field_10382)) continue;
            int rayRes = this.colorFromRaycast(pos, direction, result.get(i), !hasHitWater || transparent, entityResult);
            double[] c1 = ColorHelper.unpackColor(color);
            double[] c2 = ColorHelper.unpackColor(rayRes);
            color = ColorHelper.packColor(ColorHelper.alphaComposite(c1, c2));
            hasHitWater |= isWater;
            if ((color >> 24 & 0xFF) < 255) continue;
            return color;
        }
        return color;
    }

    private int colorFromRaycast(class_243 pos, class_243 direction, BlockIterator.WorldHit result, boolean allowWater, List<EntityIterator.EntityHit> entityHits) {
        double[] shadeTint = new double[]{1.0, 1.0, 1.0, 1.0};
        boolean blockLight = !ModConfig.getInstance().fullbright;
        class_2338 blockPos = result.blockPos();
        class_2680 blockState = result.blockState();
        int modelColor = 0xFFFFFF;
        class_2338 lightPos = result.blockPos();
        if (!blockState.method_26215() || !entityHits.isEmpty()) {
            int i;
            Object rpModels = null;
            RPModel.View rpModel = null;
            if (blockState.method_27852(class_2246.field_10382)) {
                rpModel = BuiltinModels.liquidModel(result.fluidState(), result.fluidStateAbove());
            } else if (blockState.method_27852(class_2246.field_10164)) {
                rpModel = BuiltinModels.liquidModel(result.fluidState(), result.fluidStateAbove());
            } else if (blockState.method_27852(class_2246.field_10027)) {
                rpModel = BuiltinModels.portalModel(true);
            } else if (blockState.method_27852(class_2246.field_10613)) {
                rpModel = BuiltinModels.portalModel(false);
            } else if (blockState.method_27852(class_2246.field_10034)) {
                rpModel = BuiltinModels.chestModel(blockState);
            } else if (blockState.method_27852(class_2246.field_10443)) {
                rpModel = BuiltinModels.chestModel(blockState);
            } else if (blockState.method_26164(class_3481.field_21490)) {
                rpModel = BuiltinModels.shulkerModel(blockState, Optional.ofNullable(((class_2480)result.blockState().method_26204()).method_10528()));
            } else if (blockState.method_26164(class_3481.field_16443)) {
                rpModel = BuiltinModels.bedModel(blockState, Optional.of(((class_2244)blockState.method_26204()).method_9487()));
            } else if (blockState.method_27852(class_2246.field_42752)) {
                rpModel = BuiltinModels.decoratedPotModel();
            } else if (blockState.method_27852(class_2246.field_10502)) {
                rpModel = BuiltinModels.conduitModel();
            } else if (blockState.method_26164(class_3481.field_41282)) {
                rpModel = BuiltinModels.signModel(blockState);
            } else {
                rpModels = blockState.method_27852((class_2248)ModBlocks.COMPUTER) ? BuiltinModels.computerModel(blockState) : RPHelper.loadBlockModelViews(blockState);
            }
            if (rpModels == null) {
                ObjectArrayList objectArrayList = rpModels = rpModel != null ? ObjectArrayList.of((Object[])new RPModel.View[]{rpModel}) : ObjectArrayList.of();
            }
            if (blockState.method_27852(class_2246.field_16332)) {
                rpModels.add(BuiltinModels.bellModel(blockState));
            }
            List<RenderModel> renderModels = this.getBlockRenderModels((List<RPModel.View>)rpModels, result, allowWater);
            int blockColor = this.getBlurredBiomeWaterOrBlockColor(blockPos, result.isWaterOrWaterlogged() ? null : blockState, ModConfig.getInstance().biomeBlend);
            ObjectArrayList hits = new ObjectArrayList();
            for (i = 0; i < renderModels.size(); ++i) {
                hits.addAll(renderModels.get(i).intersect(pos.method_46409(), direction.method_46409(), blockPos.method_46558().method_46409(), blockColor));
            }
            if (ModConfig.getInstance().renderEntities) {
                for (i = 0; i < entityHits.size(); ++i) {
                    EntityIterator.EntityHit hit = entityHits.get(i);
                    RPModel.View view = BuiltinEntityModels.getModel(hit.type(), blockPos.method_46558().method_46409().sub(hit.position()).add(0.0f, -0.5f, 0.0f), hit.rotation(), hit.uuid(), hit.data());
                    RenderModel entityModel = this.createOrGetCached(view);
                    hits.addAll(entityModel.intersect(pos.method_46409(), direction.method_46409(), blockPos.method_46558().method_46409(), blockColor));
                }
            }
            hits.sort(Comparator.comparingDouble(RenderModel.ModelHit::t));
            for (i = 0; i < hits.size(); ++i) {
                RenderModel.ModelHit modelHit = (RenderModel.ModelHit)hits.get(i);
                if (modelHit.direction() != null && blockState.method_26216()) {
                    lightPos = result.blockPos().method_10093(modelHit.direction());
                }
                modelColor = ColorHelper.alphaComposite(modelColor, modelHit.color());
                if (modelHit.shade() && modelHit.direction() != null) {
                    Vector3f normal = new Vector3f((Vector3fc)modelHit.direction().method_62676().method_46409());
                    modelColor = this.getShaded(modelColor, normal);
                }
                blockLight = modelHit.light();
                if ((modelColor >> 24 & 0xFF) >= 255) break;
            }
        }
        if (blockLight) {
            int lightLevel = Math.max(this.level.method_8314(class_1944.field_9284, lightPos) - this.skyDarken, this.level.method_8314(class_1944.field_9282, lightPos));
            for (int i = 1; i < shadeTint.length; ++i) {
                shadeTint[i] = shadeTint[i] * (double)((float)class_3532.method_15340((int)(lightLevel + 5), (int)5, (int)20) / 20.0f);
            }
        }
        int tintedColor = ColorHelper.multiplyColor(modelColor, ColorHelper.packColor(shadeTint));
        return tintedColor;
    }

    public int getBlurredBiomeWaterOrBlockColor(class_2338 blockPos, class_2680 blockState, int radius) {
        if (radius == 0) {
            if (blockState == null) {
                return BlockColors.biomeWaterColor(this.blockIterator.getChunkAt(blockPos), blockPos);
            }
            return BlockColors.get(this.blockIterator.getChunkAt(blockPos), blockState, blockPos);
        }
        int aSum = 0;
        int rSum = 0;
        int gSum = 0;
        int bSum = 0;
        int count = 0;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                class_2338 b = blockPos.method_10069(dx, 0, dy);
                int argb = blockState == null ? BlockColors.biomeWaterColor(this.blockIterator.getChunkAt(b), b) : BlockColors.get(this.blockIterator.getChunkAt(b), blockState, b);
                int alpha = argb >> 24 & 0xFF;
                int red = argb >> 16 & 0xFF;
                int green = argb >> 8 & 0xFF;
                int blue = argb & 0xFF;
                aSum += alpha;
                rSum += red;
                gSum += green;
                bSum += blue;
                ++count;
            }
        }
        int avgAlpha = aSum / count;
        int avgRed = rSum / count;
        int avgGreen = gSum / count;
        int avgBlue = bSum / count;
        return avgAlpha << 24 | avgRed << 16 | avgGreen << 8 | avgBlue;
    }

    private List<TriangleModel> createOrGetCached(class_2338 blockPos, class_2680 blockState, List<RPModel.View> views) {
        List<TriangleModel> models = this.createOrGetCached0(blockState, views);
        if (blockState.method_27852((class_2248)ModBlocks.COMPUTER)) {
            ObjectArrayList texturedModels = new ObjectArrayList();
            String posString = blockPos.method_10263() + "/" + blockPos.method_10264() + "/" + blockPos.method_10260();
            class_2960 texture = class_2960.method_60655((String)"dyn.d", (String)posString);
            for (TriangleModel model : models) {
                texturedModels.add(model.withTexture("display", texture));
            }
            return texturedModels;
        }
        return models;
    }

    private List<TriangleModel> createOrGetCached0(class_2680 blockState, List<RPModel.View> views) {
        if (renderModelCache.containsKey(blockState)) {
            return renderModelCache.get(blockState);
        }
        List list = renderModelCache.computeIfAbsent(blockState, k -> new ObjectArrayList());
        for (int i = 0; i < views.size(); ++i) {
            TriangleModel model = new TriangleModel(views.get(i));
            list.add(model);
        }
        return list;
    }

    private RenderModel createOrGetCached(int fluidLevel, RPModel.View view) {
        if (fluidRenderModelCache.containsKey(fluidLevel)) {
            return (RenderModel)fluidRenderModelCache.get(fluidLevel);
        }
        TriangleModel model = new TriangleModel(view);
        fluidRenderModelCache.put(fluidLevel, (Object)model);
        return model;
    }

    private RenderModel createOrGetCached(RPModel.View view) {
        TriangleModel model = new TriangleModel(view);
        return model;
    }

    private List<RenderModel> getBlockRenderModels(List<RPModel.View> views, BlockIterator.WorldHit result, boolean allowWater) {
        ReferenceArrayList renderModels = new ReferenceArrayList();
        if (views == null || views.isEmpty()) {
            return renderModels;
        }
        if (allowWater && result.isWaterOrWaterlogged() && !result.blockState().method_27852(class_2246.field_10382)) {
            RPModel.View lm = BuiltinModels.liquidModel(result.fluidState(), result.fluidStateAbove());
            renderModels.add(this.createOrGetCached(result.fluidState().method_15761() + (result.fluidState().method_15772() == result.fluidStateAbove().method_15772() ? 1 : 0) + (result.fluidState().method_15767(class_3486.field_15518) ? 100 : 0), lm));
        }
        renderModels.addAll(this.createOrGetCached(result.blockPos(), result.blockState(), views));
        return renderModels;
    }

    private int getShaded(int color, Vector3f normal) {
        double[] pc = ColorHelper.unpackColor(color);
        float b = Math.max(0.0f, normal.dot((Vector3fc)SUN));
        for (int i = 1; i < pc.length; ++i) {
            pc[i] = pc[i] * (double)(b / 3.0f + 0.7f);
        }
        return ColorHelper.packColor(pc);
    }

    private int skyColorWithClouds(class_243 pos, class_243 direction) {
        List<RenderModel.ModelHit> hits = localSkyModel.intersect(pos.method_46409(), direction.method_46409().mul((float)this.distance), new Vector3f((float)((int)pos.method_10216()), 0.0f, (float)((int)pos.field_1350)), 0);
        int color = 0;
        if (!hits.isEmpty() && (hits.getFirst().color() >> 24 & 0xFF) > 0) {
            color = ColorHelper.alphaComposite(color, hits.getFirst().color() & 0xFFFFFF | 0x44000000);
        }
        float darkness = (float)this.skyDarken / 12.0f;
        int skyColor = ColorHelper.alphaComposite(class_9848.method_61324((int)((int)(darkness * 255.0f)), (int)0, (int)0, (int)0), MiscColors.SKY_COLOR);
        return ColorHelper.alphaComposite(color, skyColor);
    }

    public static void clearCache() {
        renderModelCache.clear();
        fluidRenderModelCache.clear();
    }
}

