/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.model.resource;

import com.google.gson.annotations.SerializedName;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import de.tomalbrc.cameraobscura.util.RPHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import org.joml.Vector3fc;
import org.spongepowered.include.com.google.common.collect.ImmutableList;

public class RPModel {
    @SerializedName(value="texture_size")
    public List<Integer> textureSize = ImmutableList.of((Object)16, (Object)16);
    public class_2960 parent;
    public Object2ObjectOpenHashMap<String, String> textures;
    public List<RPElement> elements;

    public record View(RPModel model, Vector3fc blockRotation, Vector3fc offset, boolean uvlock) {
        public View(RPModel model, Vector3fc blockRotation, Vector3fc offset) {
            this(model, blockRotation, offset, false);
        }

        public View(RPModel model, Vector3fc blockRotation, boolean uvlock) {
            this(model, blockRotation, (Vector3fc)class_243.field_1353.method_46409(), uvlock);
        }

        public View(RPModel model, Vector3fc blockRotation) {
            this(model, blockRotation, (Vector3fc)class_243.field_1353.method_46409(), false);
        }

        public Map<String, class_2960> collectTextures() {
            Object2ObjectOpenHashMap collectedTextures = new Object2ObjectOpenHashMap();
            if (this.model.textures != null && !this.model.textures.isEmpty()) {
                for (Map.Entry entry : this.model.textures.entrySet()) {
                    collectedTextures.put((String)entry.getKey(), CachedResourceLocationDeserializer.get(((String)entry.getValue()).replace("#", "")));
                }
            }
            class_2960 parent = this.model.parent;
            while (parent != null && !parent.method_12832().isEmpty()) {
                View child = RPHelper.loadModelView(parent, this.blockRotation, this.uvlock);
                if (child.model == null) break;
                if (child.model.textures != null) {
                    child.model.textures.forEach((arg_0, arg_1) -> View.lambda$collectTextures$0((Map)collectedTextures, arg_0, arg_1));
                }
                parent = child.model.parent;
            }
            return collectedTextures;
        }

        public List<RPElement> collectElements() {
            if (this.model.elements != null) {
                return this.model.elements;
            }
            class_2960 parent = this.model.parent;
            while (parent != null) {
                View child = RPHelper.loadModelView(parent, this.blockRotation, this.uvlock);
                if (child.model == null) break;
                if (child.model.elements != null) {
                    return child.model.elements;
                }
                parent = child.model.parent;
            }
            return new ObjectArrayList();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            View view = (View)o;
            return this.uvlock == view.uvlock && this.model == view.model && Objects.equals(this.blockRotation, view.blockRotation) && Objects.equals(this.offset, view.offset);
        }

        private static /* synthetic */ void lambda$collectTextures$0(Map collectedTextures, String key, String value) {
            collectedTextures.putIfAbsent(key, CachedResourceLocationDeserializer.get(value.replace("#", "")));
        }
    }
}

