/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.model.triangle;

import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Triangle {
    private final Vector3f v0;
    private final Vector3f v1;
    private final Vector3f v2;
    private final Vector2f uv0;
    private final Vector2f uv1;
    private final Vector2f uv2;
    private Vector3f v0v1;
    private Vector3f v0v2;
    private Vector3f normal;
    public RPElement.TextureInfo textureInfo;
    public boolean shade;
    public boolean light;
    private class_2350 direction;

    public Triangle(Vector3f v0, Vector3f v1, Vector3f v2, Vector2f uv0, Vector2f uv1, Vector2f uv2) {
        this.v0 = v0;
        this.v1 = v1;
        this.v2 = v2;
        this.uv0 = uv0;
        this.uv1 = uv1;
        this.uv2 = uv2;
        this.recalculateVectors();
        this.setDirection((Vector3fc)this.normal);
        this.shade = true;
    }

    public void setDirection(Vector3fc dir) {
        this.direction = Triangle.fromDelta((int)dir.x(), (int)dir.y(), (int)dir.z());
    }

    @Nullable
    public static class_2350 fromDelta(int x, int y, int z) {
        if (x == 0) {
            if (y == 0) {
                if (z > 0) {
                    return class_2350.field_11035;
                }
                if (z < 0) {
                    return class_2350.field_11043;
                }
            } else if (z == 0) {
                if (y > 0) {
                    return class_2350.field_11036;
                }
                return class_2350.field_11033;
            }
        } else if (y == 0 && z == 0) {
            if (x > 0) {
                return class_2350.field_11034;
            }
            return class_2350.field_11039;
        }
        return null;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public void rotate(Quaternionf quaternionf) {
        this.v0.rotate((Quaternionfc)quaternionf);
        this.v1.rotate((Quaternionfc)quaternionf);
        this.v2.rotate((Quaternionfc)quaternionf);
    }

    public void translate(float x, float y, float z) {
        this.v0.sub(x, y, z);
        this.v1.sub(x, y, z);
        this.v2.sub(x, y, z);
    }

    public void recalculateVectors() {
        this.v0v1 = this.v1.sub((Vector3fc)this.v0, new Vector3f());
        this.v0v2 = this.v2.sub((Vector3fc)this.v0, new Vector3f());
        this.normal = this.v0v1.cross((Vector3fc)this.v0v2, new Vector3f()).normalize();
    }

    public Vector3fc getNormal() {
        return this.normal;
    }

    public TriangleHit rayIntersect(Vector3f orig, Vector3f dir) {
        Vector3f pvec = dir.cross((Vector3fc)this.v0v2, new Vector3f());
        float det = this.v0v1.dot((Vector3fc)pvec);
        if (det < 1.0E-5f) {
            return null;
        }
        float invDet = 1.0f / det;
        Vector3f tvec = orig.sub((Vector3fc)this.v0, new Vector3f());
        float u = tvec.dot((Vector3fc)pvec) * invDet;
        if (u < 0.0f || u > 1.0f) {
            return null;
        }
        Vector3f qvec = tvec.cross((Vector3fc)this.v0v1, new Vector3f());
        float v = dir.dot((Vector3fc)qvec) * invDet;
        if (v < 0.0f || u + v > 1.0f) {
            return null;
        }
        float t = this.v0v2.dot((Vector3fc)qvec) * invDet;
        float w = 1.0f - u - v;
        float uCoord = u * this.uv0.x + v * this.uv1.x + w * this.uv2.x;
        float vCoord = u * this.uv0.y + v * this.uv1.y + w * this.uv2.y;
        return new TriangleHit(t, (Vector2fc)new Vector2f(uCoord, vCoord), this);
    }

    public record TriangleHit(float t, Vector2fc uv, Triangle triangle) {
    }
}

