/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.render.renderer;

import de.tomalbrc.cameraobscura.render.Raytracer;
import de.tomalbrc.cameraobscura.render.renderer.Renderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_243;

public abstract class AbstractRenderer<T>
implements Renderer<T> {
    protected final int width;
    protected final int height;
    protected final class_1309 entity;
    protected final Raytracer raytracer;

    public AbstractRenderer(class_1309 entity, int width, int height, int renderDistance) {
        this.entity = entity;
        this.width = width;
        this.height = height;
        this.raytracer = new Raytracer(this.entity, renderDistance);
    }

    public static class_243 yawPitchRotation(class_243 base, double angleYaw, double anglePitch) {
        double oldX = base.method_10216();
        double oldY = base.method_10214();
        double oldZ = base.method_10215();
        double sinOne = Math.sin(angleYaw);
        double sinTwo = Math.sin(anglePitch);
        double cosOne = Math.cos(angleYaw);
        double cosTwo = Math.cos(anglePitch);
        double newX = oldX * cosOne * cosTwo - oldY * cosOne * sinTwo - oldZ * sinOne;
        double newY = oldX * sinTwo + oldY * cosTwo;
        double newZ = oldX * sinOne * cosTwo - oldY * sinOne * sinTwo + oldZ * cosOne;
        return new class_243(newX, newY, newZ);
    }

    public static class_243 doubleYawPitchRotation(class_243 base, double firstYaw, double firstPitch, double secondYaw, double secondPitch) {
        return AbstractRenderer.yawPitchRotation(AbstractRenderer.yawPitchRotation(base, firstYaw, firstPitch), secondYaw, secondPitch);
    }

    protected List<Ray> castRays(class_1309 entity) {
        ArrayList<Ray> rays = new ArrayList<Ray>();
        double yawRad = (entity.field_6241 + 90.0f) * ((float)Math.PI / 180);
        double pitchRad = -entity.method_36455() * ((float)Math.PI / 180);
        class_243 baseVec = new class_243(1.0, 0.0, 0.0);
        class_243 lowerLeft = AbstractRenderer.doubleYawPitchRotation(baseVec, -FOV_YAW_RAD, -FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 upperLeft = AbstractRenderer.doubleYawPitchRotation(baseVec, -FOV_YAW_RAD, FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 lowerRight = AbstractRenderer.doubleYawPitchRotation(baseVec, FOV_YAW_RAD, -FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 upperRight = AbstractRenderer.doubleYawPitchRotation(baseVec, FOV_YAW_RAD, FOV_PITCH_RAD, yawRad, pitchRad);
        class_243 leftFraction = upperLeft.method_1020(lowerLeft).method_1021(1.0 / ((double)this.height - 1.0));
        class_243 rightFraction = upperRight.method_1020(lowerRight).method_1021(1.0 / ((double)this.height - 1.0));
        for (int pitch = 0; pitch < this.height; ++pitch) {
            class_243 leftPitch = upperLeft.method_1020(leftFraction.method_1021((double)pitch));
            class_243 rightPitch = upperRight.method_1020(rightFraction.method_1021((double)pitch));
            class_243 yawFraction = rightPitch.method_1020(leftPitch).method_1021(1.0 / ((double)this.width - 1.0));
            for (int yaw = 0; yaw < this.width; ++yaw) {
                class_243 ray = leftPitch.method_1019(yawFraction.method_1021((double)yaw)).method_1029();
                rays.add(new Ray(ray, yaw, pitch));
            }
        }
        return rays;
    }

    public record Ray(class_243 direction, int xOrigin, int yOrigin) {
    }
}

