/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.util;

import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import de.tomalbrc.cameraobscura.render.model.resource.RPModel;
import de.tomalbrc.cameraobscura.util.RPHelper;
import de.tomalbrc.cameraobscura.util.model.BedModel;
import de.tomalbrc.cameraobscura.util.model.BellModel;
import de.tomalbrc.cameraobscura.util.model.ChestModel;
import de.tomalbrc.cameraobscura.util.model.ConduitModel;
import de.tomalbrc.cameraobscura.util.model.DecoratedPotModel;
import de.tomalbrc.cameraobscura.util.model.LiquidModel;
import de.tomalbrc.cameraobscura.util.model.PortalModel;
import de.tomalbrc.cameraobscura.util.model.ShulkerModel;
import de.tomalbrc.cameraobscura.util.model.SignModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.drex.nem.block.ComputerBlock;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class BuiltinModels {
    static Map<class_2680, RPModel.View> modelMap = new Reference2ObjectArrayMap();
    static Int2ObjectOpenHashMap<RPModel.View> waterModels = new Int2ObjectOpenHashMap();
    static Int2ObjectOpenHashMap<RPModel.View> lavaModels = new Int2ObjectOpenHashMap();
    static RPModel.View portalModel = null;
    static RPModel.View portalBlockModel = null;
    static RPModel.View decoratedPotModel = null;
    static RPModel.View conduitModel = null;
    static RPModel.View skyModel = null;
    static RPModel displayModel = null;

    public static RPModel.View liquidModel(class_3610 fluidState, class_3610 fluidStateAbove) {
        int height;
        int n = height = fluidStateAbove.method_15769() ? (fluidState.method_15761() - 1) * 2 : 16;
        if (fluidState.method_15767(class_3486.field_15517) && waterModels.containsKey(height)) {
            return (RPModel.View)waterModels.get(height);
        }
        if (fluidState.method_15767(class_3486.field_15518) && lavaModels.containsKey(height)) {
            return (RPModel.View)lavaModels.get(height);
        }
        RPModel.View view = LiquidModel.get(fluidState, fluidStateAbove);
        if (fluidState.method_15767(class_3486.field_15517)) {
            waterModels.put(height, (Object)view);
        }
        if (fluidState.method_15767(class_3486.field_15518)) {
            lavaModels.put(height, (Object)view);
        }
        return view;
    }

    public static RPModel.View portalModel(boolean flat) {
        if (flat && portalModel != null) {
            return portalModel;
        }
        if (portalBlockModel != null) {
            return portalBlockModel;
        }
        RPModel.View view = PortalModel.get(flat);
        if (flat) {
            portalModel = view;
        } else {
            portalBlockModel = view;
        }
        return view;
    }

    public static RPModel.View chestModel(class_2680 chestBlockState) {
        if (modelMap.containsKey(chestBlockState)) {
            return modelMap.get(chestBlockState);
        }
        RPModel.View model = ChestModel.get(chestBlockState);
        modelMap.put(chestBlockState, model);
        return model;
    }

    public static RPModel.View bedModel(class_2680 chestBlockState, Optional<class_1767> color) {
        if (modelMap.containsKey(chestBlockState)) {
            return modelMap.get(chestBlockState);
        }
        RPModel.View model = BedModel.get(chestBlockState, color);
        modelMap.put(chestBlockState, model);
        return model;
    }

    public static RPModel.View shulkerModel(class_2680 blockState, Optional<class_1767> color) {
        if (modelMap.containsKey(blockState)) {
            return modelMap.get(blockState);
        }
        RPModel.View model = ShulkerModel.get(blockState, color);
        modelMap.put(blockState, model);
        return model;
    }

    public static RPModel.View decoratedPotModel() {
        if (decoratedPotModel != null) {
            return decoratedPotModel;
        }
        decoratedPotModel = DecoratedPotModel.get();
        return decoratedPotModel;
    }

    public static RPModel.View conduitModel() {
        if (conduitModel != null) {
            return conduitModel;
        }
        conduitModel = ConduitModel.get();
        return conduitModel;
    }

    public static RPModel.View signModel(class_2680 blockState) {
        if (modelMap.containsKey(blockState)) {
            return modelMap.get(blockState);
        }
        RPModel.View model = SignModel.get(blockState);
        modelMap.put(blockState, model);
        return model;
    }

    public static RPModel.View bellModel(class_2680 blockState) {
        if (modelMap.containsKey(blockState)) {
            return modelMap.get(blockState);
        }
        RPModel.View model = BellModel.get();
        modelMap.put(blockState, model);
        return model;
    }

    public static RPModel.View skyModel(class_243 pos) {
        RPModel.View view;
        if (skyModel != null) {
            return skyModel;
        }
        RPModel rpModel = new RPModel();
        rpModel.parent = CachedResourceLocationDeserializer.get("minecraft:block/cube_all");
        rpModel.textures = new Object2ObjectOpenHashMap();
        rpModel.textures.put((Object)"all", (Object)"minecraft:environment/clouds");
        rpModel.elements = new ObjectArrayList();
        RPElement element = new RPElement();
        element.from = new Vector3f(-8192.0f, 0.0f, -8192.0f);
        element.to = new Vector3f(8192.0f, 0.0f, 8192.0f);
        element.faces = new Object2ObjectOpenHashMap();
        RPElement.TextureInfo ti = new RPElement.TextureInfo();
        ti.texture = "#all";
        ti.uv = new Vector4f(0.0f, 0.0f, 32.0f, 32.0f);
        element.faces.put("down", ti);
        rpModel.elements.add(element);
        skyModel = view = new RPModel.View(rpModel, (Vector3fc)new Vector3f(), (Vector3fc)pos.method_46409());
        return view;
    }

    public static RPModel displayModel() {
        if (displayModel == null) {
            displayModel = RPHelper.loadModel(BuiltinModels.class.getResourceAsStream("/builtin/display.json"));
        }
        return displayModel;
    }

    public static List<RPModel.View> computerModel(class_2680 blockState) {
        ObjectArrayList views = RPHelper.loadBlockModelViews(blockState);
        if (views == null) {
            return null;
        }
        views = new ObjectArrayList(views);
        RPModel model = BuiltinModels.displayModel();
        class_2350 direction = (class_2350)blockState.method_11654((class_2769)ComputerBlock.field_11177);
        views.add(new RPModel.View(model, (Vector3fc)new Vector3f(0.0f, direction.method_10144(), 0.0f)));
        return views;
    }
}

