/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.json.ConditionDeserializer;
import de.tomalbrc.cameraobscura.json.MultipartDefinitionDeserializer;
import de.tomalbrc.cameraobscura.json.VariantDeserializer;
import de.tomalbrc.cameraobscura.json.Vector3fDeserializer;
import de.tomalbrc.cameraobscura.json.Vector4fDeserializer;
import de.tomalbrc.cameraobscura.render.model.resource.RPBlockState;
import de.tomalbrc.cameraobscura.render.model.resource.RPElement;
import de.tomalbrc.cameraobscura.render.model.resource.RPModel;
import de.tomalbrc.cameraobscura.render.model.resource.state.MultipartDefinition;
import de.tomalbrc.cameraobscura.render.model.resource.state.Variant;
import de.tomalbrc.cameraobscura.util.TextureHelper;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.core.api.block.PolymerBlock;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import me.drex.nem.block.model.ComputerModel;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7367;
import net.minecraft.class_7923;
import nl.theepicblock.resourcelocatorapi.ResourceLocatorApi;
import nl.theepicblock.resourcelocatorapi.api.AssetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import xyz.nucleoid.packettweaker.PacketContext;

public class RPHelper {
    private static final AssetContainer GLOBAL_ASSETS = ResourceLocatorApi.createGlobalAssetContainer();
    private static final Map<class_2960, RPModel> modelResources = new ConcurrentHashMap<class_2960, RPModel>();
    private static final Map<class_2680, RPBlockState> blockStateResources = new ConcurrentHashMap<class_2680, RPBlockState>();
    private static final Map<class_2960, BufferedImage> textureCache = new ConcurrentHashMap<class_2960, BufferedImage>();
    private static FileSystem vanillaFilesystem;
    public static final Gson gson;
    private static final Map<class_2680, List<RPModel.View>> blockModelCache;

    public static void clearCache() {
        modelResources.clear();
        blockStateResources.clear();
        textureCache.clear();
    }

    public static void init() {
        try {
            Path clientJar = PolymerCommonUtils.getClientJar();
            if (clientJar == null) {
                throw new RuntimeException("Could not get client jar");
            }
            vanillaFilesystem = FileSystems.newFileSystem(clientJar);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream getAsset(class_2960 location, String type, String extension) {
        class_7367 supplier = GLOBAL_ASSETS.getAsset(location.method_12836(), type + "/" + location.method_12832() + extension);
        if (supplier == null) {
            try {
                Path path = vanillaFilesystem.getPath("/assets/" + location.method_12836() + "/" + type + "/" + location.method_12832() + extension, new String[0]);
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        try {
            return (InputStream)supplier.get();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    public static RPBlockState loadBlockState(class_2680 blockState) {
        if (blockStateResources.containsKey(blockState)) {
            return blockStateResources.get(blockState);
        }
        class_2960 location = class_7923.field_41175.method_10221((Object)blockState.method_26204());
        InputStream inputStream = RPHelper.getAsset(location, "blockstates", ".json");
        if (inputStream != null) {
            RPBlockState resource = (RPBlockState)gson.fromJson((Reader)new InputStreamReader(inputStream), RPBlockState.class);
            blockStateResources.put(blockState, resource);
            return resource;
        }
        return null;
    }

    public static RPModel.View loadModelView(class_2960 resourceLocation, Vector3fc blockRotation, boolean uvlock) {
        return new RPModel.View(RPHelper.loadModel(resourceLocation), blockRotation, uvlock);
    }

    public static RPModel loadModel(class_2960 resourceLocation) {
        if (modelResources.containsKey(resourceLocation)) {
            return modelResources.get(resourceLocation);
        }
        InputStream inputStream = RPHelper.getAsset(resourceLocation, "models", ".json");
        if (inputStream != null) {
            RPModel model = RPHelper.loadModel(inputStream);
            modelResources.put(resourceLocation, model);
            return model;
        }
        return null;
    }

    public static RPModel loadModel(InputStream inputStream) {
        RPModel model = (RPModel)gson.fromJson((Reader)new InputStreamReader(inputStream), RPModel.class);
        if (model.elements != null) {
            for (int i = 0; i < model.elements.size(); ++i) {
                RPElement element = model.elements.get(i);
                for (Map.Entry<String, RPElement.TextureInfo> stringTextureInfoEntry : element.faces.entrySet()) {
                    if (stringTextureInfoEntry.getValue().uv != null) continue;
                    stringTextureInfoEntry.getValue().uv = new Vector4f(element.from.x(), element.from.y(), element.to.x(), element.to.y());
                }
            }
        }
        return model;
    }

    public static InputStream getTexture(class_2960 location) {
        return RPHelper.getAsset(location, "textures", ".png");
    }

    public static BufferedImage loadTextureImage(class_2960 path) {
        if (textureCache.containsKey(path)) {
            return textureCache.get(path);
        }
        if (path.method_12836().equals("dyn.p")) {
            BufferedImage img = RPHelper.imageFromBytes(RPHelper.getPlayerTexture(path.method_12832()));
            textureCache.put(path, img);
            return img;
        }
        if (path.method_12836().equals("dyn.d")) {
            return RPHelper.getDisplayTexture(path.method_12832());
        }
        try {
            InputStream inputStream = RPHelper.getTexture(path);
            BufferedImage img = RPHelper.imageFromBytes(inputStream);
            textureCache.put(path, img);
            return img;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static BufferedImage imageFromBytes(InputStream inputStream) {
        BufferedImage img = null;
        try {
            img = ImageIO.read(inputStream);
            if (img.getType() == 10) {
                img = TextureHelper.darkenGrayscale(img);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return img;
    }

    @NotNull
    private static InputStream getPlayerTexture(String uuid) {
        InputStreamReader inputStreamReader = null;
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
            inputStreamReader = new InputStreamReader(url.openStream());
            JsonObject textureProperty = new JsonParser().parse((Reader)inputStreamReader).getAsJsonObject().get("properties").getAsJsonArray().get(0).getAsJsonObject();
            String texture = textureProperty.get("value").getAsString();
            String newJson = new String(Base64.getDecoder().decode(texture));
            String str = new JsonParser().parse(newJson).getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString();
            URL textureUrl = new URL(str);
            return textureUrl.openStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static BufferedImage getDisplayTexture(String posString) {
        String[] split = posString.split("/");
        class_2338 blockPos = new class_2338(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        return ComputerModel.renderedFrames.get(blockPos);
    }

    public static List<RPModel.View> loadModel(RPBlockState rpBlockState, class_2680 blockState) {
        if (rpBlockState != null && rpBlockState.variants != null) {
            for (Map.Entry<String, Variant> entry : rpBlockState.variants.entrySet()) {
                boolean matches = true;
                if (!entry.getKey().isEmpty()) {
                    try {
                        String str = String.format("%s[%s]", class_7923.field_41175.method_10221((Object)blockState.method_26204()), entry.getKey());
                        class_2259.class_7211 blockResult = class_2259.method_41957((class_7225)class_7923.field_41175, (String)str, (boolean)false);
                        for (Map.Entry propertyComparableEntry : blockResult.comp_623().entrySet()) {
                            if (blockState.method_11654((class_2769)propertyComparableEntry.getKey()).equals(propertyComparableEntry.getValue())) continue;
                            matches = false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
                if (!entry.getKey().isEmpty() && !matches) continue;
                RPModel.View model = RPHelper.loadModelView(entry.getValue().model, (Vector3fc)new Vector3f((float)entry.getValue().x, (float)entry.getValue().y, (float)entry.getValue().z), entry.getValue().uvlock);
                return ObjectArrayList.of((Object[])new RPModel.View[]{model});
            }
        } else if (rpBlockState != null && rpBlockState.multipart != null) {
            ObjectArrayList list = new ObjectArrayList();
            int num = rpBlockState.multipart.size();
            for (int i = 0; i < num; ++i) {
                MultipartDefinition mp = rpBlockState.multipart.get(i);
                if (mp.when != null && !mp.when.canApply(blockState)) continue;
                for (int applyIndex = 0; applyIndex < mp.apply.size(); ++applyIndex) {
                    Variant apply = mp.apply.get(applyIndex);
                    RPModel.View model = RPHelper.loadModelView(apply.model, (Vector3fc)new Vector3f((float)apply.x, (float)apply.y, (float)apply.z), apply.uvlock);
                    list.add((Object)model);
                }
            }
            return list;
        }
        return null;
    }

    public static List<RPModel.View> loadBlockModelViews(class_2680 blockState) {
        if (blockModelCache.containsKey(blockState)) {
            return blockModelCache.get(blockState);
        }
        RPBlockState rpBlockState = RPHelper.loadBlockState(blockState);
        if (rpBlockState != null) {
            List<RPModel.View> views = RPHelper.loadModel(rpBlockState, blockState);
            blockModelCache.put(blockState, views);
            return views;
        }
        return null;
    }

    public static RPModel loadItemModel(class_1799 itemStack) {
        class_2960 resourceLocation = class_7923.field_41178.method_10221((Object)itemStack.method_7909());
        return RPHelper.loadModel(resourceLocation.method_45136("item/" + resourceLocation.method_12832()));
    }

    private static class_2680 safePolymerBlockState(class_2680 blockState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PolymerBlock) {
            PolymerBlock polymerBlock = (PolymerBlock)class_22482;
            blockState = polymerBlock.getPolymerBlockState(blockState, PacketContext.get());
        }
        return blockState;
    }

    static {
        gson = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new CachedResourceLocationDeserializer()).registerTypeAdapter(Variant.class, (Object)new VariantDeserializer()).registerTypeAdapter(MultipartDefinition.class, (Object)new MultipartDefinitionDeserializer()).registerTypeAdapter(MultipartDefinition.Condition.class, (Object)new ConditionDeserializer()).registerTypeAdapter(Vector3f.class, (Object)new Vector3fDeserializer()).registerTypeAdapter(Vector4f.class, (Object)new Vector4fDeserializer()).create();
        blockModelCache = new ConcurrentHashMap<class_2680, List<RPModel.View>>();
    }
}

