/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.world;

import de.tomalbrc.cameraobscura.world.CustomBlockIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_4076;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BlockIterator {
    protected final class_3218 level;
    private final class_2818[][] loadedChunks;
    private final class_2818 fallbackChunk;
    private final int centerX;
    private final int centerZ;
    private final int chunkRadius;

    public BlockIterator(class_3218 level, class_1309 entity, int distance) {
        this.level = level;
        this.fallbackChunk = new class_2812((class_1937)this.level, class_1923.field_35107, (class_6880)level.method_30349().method_30530(class_7924.field_41236).method_46747(class_1972.field_9451));
        class_2338 center = entity.method_23312();
        this.centerX = class_4076.method_18675((int)center.method_10263());
        this.centerZ = class_4076.method_18675((int)center.method_10260());
        this.chunkRadius = distance / 16;
        this.loadedChunks = new class_2818[this.chunkRadius * 2 + 1][this.chunkRadius * 2 + 1];
        for (int dx = -this.chunkRadius; dx <= this.chunkRadius; ++dx) {
            for (int dz = -this.chunkRadius; dz <= this.chunkRadius; ++dz) {
                this.loadedChunks[dx + this.chunkRadius][dz + this.chunkRadius] = level.method_8497(this.centerX + dx, this.centerZ + dz);
            }
        }
    }

    protected class_2818 getChunkAt(class_1923 pos) {
        int x = pos.field_9181;
        int z = pos.field_9180;
        int localX = x + this.chunkRadius - this.centerX;
        int localZ = z + this.chunkRadius - this.centerZ;
        if (localX < 0 || localX >= this.loadedChunks.length || localZ < 0 || localZ >= this.loadedChunks[0].length) {
            return this.fallbackChunk;
        }
        return this.loadedChunks[localX][localZ];
    }

    public class_2818 getChunkAt(class_2338 blockPos) {
        return this.getChunkAt(new class_1923(blockPos));
    }

    public List<WorldHit> raycast(class_3959 clipContext) {
        ObjectArrayList list = new ObjectArrayList();
        class_2818 cachedChunk = null;
        long cachedChunkKey = 0L;
        boolean cached = false;
        class_243 from = clipContext.method_17750();
        class_243 to = clipContext.method_17747();
        CustomBlockIterator blockIterator = new CustomBlockIterator(from.field_1352, from.field_1351, from.field_1350, to.field_1352, to.field_1351, to.field_1350);
        while (blockIterator.hasNext()) {
            class_3610 fluidStateAbove;
            class_3610 fluidState;
            class_2680 blockState;
            int z;
            int y;
            int[] pos = blockIterator.next();
            int x = pos[0];
            class_2338 blockPos = new class_2338(x, y = pos[1], z = pos[2]);
            class_1923 chunkPos = new class_1923(blockPos);
            long key = chunkPos.method_8324();
            if (key != cachedChunkKey || !cached) {
                cachedChunkKey = key;
                cachedChunk = this.getChunkAt(chunkPos);
                cached = true;
            }
            if (cachedChunk != null) {
                blockState = cachedChunk.method_8320(blockPos);
                fluidState = blockState.method_26227();
                fluidStateAbove = null;
                if (!fluidState.method_15769()) {
                    fluidStateAbove = cachedChunk.method_8316(blockPos.method_10084());
                }
            } else {
                blockState = class_2246.field_10124.method_9564();
                fluidState = class_3612.field_15906.method_15785();
                fluidStateAbove = class_3612.field_15906.method_15785();
            }
            if (!blockState.method_26216()) {
                if (blockState.method_26215()) continue;
                list.add(new WorldHit(new class_2338((class_2382)blockPos), blockState, fluidState, fluidStateAbove));
                continue;
            }
            if (blockState.method_26215()) continue;
            list.add(new WorldHit(new class_2338((class_2382)blockPos), blockState, fluidState, fluidStateAbove));
            break;
        }
        if (list.isEmpty()) {
            class_2680 blockState = class_2246.field_10124.method_9564();
            list.add(new WorldHit(class_2338.method_49638((class_2374)to), blockState, blockState.method_26227(), blockState.method_26227()));
        }
        return list;
    }

    public record WorldHit(class_2338 blockPos, class_2680 blockState, class_3610 fluidState, class_3610 fluidStateAbove) {
        public boolean isWaterOrWaterlogged() {
            if (this.fluidState != null && !this.fluidState.method_15769()) {
                return this.fluidState.method_15767(class_3486.field_15517);
            }
            return false;
        }
    }
}

