/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.world;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CustomBlockIterator
implements Iterator<int[]> {
    private int x;
    private int y;
    private int z;
    private int stepX;
    private int stepY;
    private int stepZ;
    private double tMax;
    private double tMaxX;
    private double tMaxY;
    private double tMaxZ;
    private double tDeltaX;
    private double tDeltaY;
    private double tDeltaZ;
    private int[] ref = new int[3];
    private int[] refSwap = new int[3];
    private int[] next;

    public CustomBlockIterator(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.initialize(startX, startY, startZ, endX, endY, endZ);
    }

    public CustomBlockIterator(int x, int y, int z, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        this.initialize(x, y, z, startX, startY, startZ, endX, endY, endZ);
    }

    public CustomBlockIterator(double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        this.initialize(startX, startY, startZ, directionX, directionY, directionZ, distance);
    }

    public CustomBlockIterator(int x, int y, int z, double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        this.initialize(x, y, z, startX, startY, startZ, directionX, directionY, directionZ, distance);
    }

    public CustomBlockIterator(double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance, boolean normalized) {
        if (normalized) {
            this.initializeNormalized(startX, startY, startZ, directionX, directionY, directionZ, distance);
        } else {
            this.initialize(startX, startY, startZ, directionX, directionY, directionZ, distance);
        }
    }

    public CustomBlockIterator(int x, int y, int z, double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance, boolean normalized) {
        if (normalized) {
            this.initializeNormalized(x, y, z, startX, startY, startZ, directionX, directionY, directionZ, distance);
        } else {
            this.initialize(x, y, z, startX, startY, startZ, directionX, directionY, directionZ, distance);
        }
    }

    public CustomBlockIterator initialize(double startX, double startY, double startZ, double endX, double endY, double endZ) {
        return this.initialize(CustomBlockIterator.floor(startX), CustomBlockIterator.floor(startY), CustomBlockIterator.floor(startZ), startX, startY, startZ, endX, endY, endZ);
    }

    public CustomBlockIterator initialize(int x, int y, int z, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        double directionX = endX - startX;
        double directionY = endY - startY;
        double directionZ = endZ - startZ;
        double distance = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
        double fixedDistance = distance == 0.0 ? Double.NaN : distance;
        return this.initializeNormalized(x, y, z, startX, startY, startZ, directionX /= fixedDistance, directionY /= fixedDistance, directionZ /= fixedDistance, distance);
    }

    public CustomBlockIterator initialize(double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        return this.initialize(CustomBlockIterator.floor(startX), CustomBlockIterator.floor(startY), CustomBlockIterator.floor(startZ), startX, startY, startZ, directionX, directionY, directionZ, distance);
    }

    public CustomBlockIterator initialize(int x, int y, int z, double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        double length;
        double signum = Math.signum(distance);
        if ((length = Math.sqrt((directionX *= signum) * directionX + (directionY *= signum) * directionY + (directionZ *= signum) * directionZ)) == 0.0) {
            length = Double.NaN;
        }
        return this.initializeNormalized(x, y, z, startX, startY, startZ, directionX /= length, directionY /= length, directionZ /= length, Math.abs(distance));
    }

    public CustomBlockIterator initializeNormalized(double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        return this.initializeNormalized(CustomBlockIterator.floor(startX), CustomBlockIterator.floor(startY), CustomBlockIterator.floor(startZ), startX, startY, startZ, directionX, directionY, directionZ, Math.abs(distance));
    }

    public CustomBlockIterator initializeNormalized(int x, int y, int z, double startX, double startY, double startZ, double directionX, double directionY, double directionZ, double distance) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.tMax = distance;
        this.stepX = directionX < 0.0 ? -1 : 1;
        this.stepY = directionY < 0.0 ? -1 : 1;
        this.stepZ = directionZ < 0.0 ? -1 : 1;
        this.tMaxX = directionX == 0.0 ? Double.POSITIVE_INFINITY : ((double)(x + (this.stepX + 1) / 2) - startX) / directionX;
        this.tMaxY = directionY == 0.0 ? Double.POSITIVE_INFINITY : ((double)(y + (this.stepY + 1) / 2) - startY) / directionY;
        this.tMaxZ = directionZ == 0.0 ? Double.POSITIVE_INFINITY : ((double)(z + (this.stepZ + 1) / 2) - startZ) / directionZ;
        this.tDeltaX = 1.0 / Math.abs(directionX);
        this.tDeltaY = 1.0 / Math.abs(directionY);
        this.tDeltaZ = 1.0 / Math.abs(directionZ);
        this.next = this.ref;
        this.ref[0] = x;
        this.ref[1] = y;
        this.ref[2] = z;
        return this;
    }

    public int[] calculateNext() {
        if (this.tMaxX < this.tMaxY) {
            if (this.tMaxZ < this.tMaxX) {
                if (this.tMaxZ <= this.tMax) {
                    this.z += this.stepZ;
                    this.ref[0] = this.x;
                    this.ref[1] = this.y;
                    this.ref[2] = this.z;
                    this.tMaxZ += this.tDeltaZ;
                } else {
                    this.next = null;
                }
            } else if (this.tMaxX <= this.tMax) {
                if (this.tMaxZ == this.tMaxX) {
                    this.z += this.stepZ;
                    this.tMaxZ += this.tDeltaZ;
                }
                this.x += this.stepX;
                this.ref[0] = this.x;
                this.ref[1] = this.y;
                this.ref[2] = this.z;
                this.tMaxX += this.tDeltaX;
            } else {
                this.next = null;
            }
        } else if (this.tMaxY < this.tMaxZ) {
            if (this.tMaxY <= this.tMax) {
                if (this.tMaxX == this.tMaxY) {
                    this.x += this.stepX;
                    this.tMaxX += this.tDeltaX;
                }
                this.y += this.stepY;
                this.ref[0] = this.x;
                this.ref[1] = this.y;
                this.ref[2] = this.z;
                this.tMaxY += this.tDeltaY;
            } else {
                this.next = null;
            }
        } else if (this.tMaxZ <= this.tMax) {
            if (this.tMaxX == this.tMaxZ) {
                this.x += this.stepX;
                this.tMaxX += this.tDeltaX;
            }
            if (this.tMaxY == this.tMaxZ) {
                this.y += this.stepY;
                this.tMaxY += this.tDeltaY;
            }
            this.z += this.stepZ;
            this.ref[0] = this.x;
            this.ref[1] = this.y;
            this.ref[2] = this.z;
            this.tMaxZ += this.tDeltaZ;
        } else {
            this.next = null;
        }
        return this.next;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public int[] next() {
        int[] next = this.next;
        if (next == null) {
            throw new NoSuchElementException();
        }
        int[] temp = this.ref;
        this.ref = this.refSwap;
        this.refSwap = temp;
        this.next = this.ref;
        this.calculateNext();
        return next;
    }

    private static int floor(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }
}

