/*
 * Decompiled with CFR 0.152.
 */
package de.tomalbrc.cameraobscura.world;

import de.tomalbrc.cameraobscura.json.CachedResourceLocationDeserializer;
import de.tomalbrc.cameraobscura.util.RPHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import me.drex.nem.config.ModConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1542;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityIterator {
    private final class_3218 level;
    private final class_1309 entity;
    private final List<EntityHit> allEntities;

    public EntityIterator(class_3218 level, class_1309 entity1) {
        this.level = level;
        this.entity = entity1;
        this.allEntities = new ObjectArrayList();
        if (ModConfig.getInstance().renderEntities) {
            List lst = this.level.method_8335((class_1297)this.entity, this.entity.method_5829().method_1014((double)ModConfig.getInstance().renderDistance));
            lst.sort(Comparator.comparingDouble(a -> a.method_73189().method_1022(entity1.method_73189())));
            for (int i = 0; i < lst.size() && this.allEntities.size() <= ModConfig.getInstance().renderEntitiesAmount; ++i) {
                EntityHit hit;
                class_1297 entity = (class_1297)lst.get(i);
                if (!this.isInFrustum(entity1.method_5828(1.0f), entity1.method_73189(), entity.method_73189(), ModConfig.getInstance().fov + 10) || !entity1.method_6057(entity)) continue;
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    hit = new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(entity.method_36455(), livingEntity.field_6283, 0.0f), entity.method_5667(), null);
                } else if (entity instanceof class_1533) {
                    class_1533 itemFrame = (class_1533)entity;
                    Quaternionf rot = itemFrame.method_5735().method_23224();
                    hit = new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)rot.getEulerAnglesXYZ(new Vector3f()).mul(57.295776f), entity.method_5667(), null);
                } else if (entity instanceof class_1542) {
                    class_1542 itemEntity = (class_1542)entity;
                    hit = new EntityHit(entity.method_5864(), entity.method_5829(), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(0.0f, itemEntity.method_73188(), 0.0f), entity.method_5667(), itemEntity.method_6983().method_7972());
                } else {
                    hit = new EntityHit(entity.method_5864(), entity.method_5829().method_1014(1.0), (Vector3fc)entity.method_73189().method_46409(), (Vector3fc)new Vector3f(entity.method_36455(), entity.method_36454(), 0.0f), entity.method_5667(), null);
                }
                if (entity.method_5864() == class_1299.field_6097) {
                    RPHelper.loadTextureImage(CachedResourceLocationDeserializer.get("dyn.p:" + entity.method_5667().toString().replace("-", "")));
                }
                this.allEntities.add(hit);
            }
        }
    }

    public boolean isInFrustum(class_243 viewVector, class_243 cameraPosition, class_243 targetPosition, float fov) {
        class_243 normalizedDirection = targetPosition.method_1020(cameraPosition).method_1029();
        class_243 normalizedViewVector = viewVector.method_1029();
        double dotProduct = normalizedViewVector.method_1026(normalizedDirection);
        return dotProduct >= Math.cos(Math.toRadians(fov) / 2.0);
    }

    public List<EntityHit> raycast(class_3959 clipContext) {
        ObjectArrayList hits = new ObjectArrayList();
        for (int i = 0; i < this.allEntities.size(); ++i) {
            EntityHit entityHit = this.allEntities.get(i);
            if (!entityHit.boundingBox().method_993(clipContext.method_17750(), clipContext.method_17747())) continue;
            hits.add(entityHit);
        }
        return hits;
    }

    public record EntityHit(class_1299 type, class_238 boundingBox, Vector3fc position, Vector3fc rotation, UUID uuid, Object data) {
    }
}

