/*
 * Decompiled with CFR 0.152.
 */
package me.drex.nem.block.model;

import com.mojang.authlib.GameProfile;
import de.tomalbrc.cameraobscura.render.renderer.ImageRenderer;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.SimpleEntityElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.polymer.virtualentity.api.tracker.DataTrackerLike;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import eu.pb4.polymer.virtualentity.api.tracker.SimpleDataTracker;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import me.drex.nem.NotEnoughMinecraft;
import me.drex.nem.block.ComputerBlock;
import me.drex.nem.config.ModConfig;
import me.drex.nem.item.ModItems;
import me.drex.nem.logic.ComputerFakePlayer;
import me.drex.nem.logic.FakeClientConnection;
import me.drex.nem.logic.PlayerAction;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_10182;
import net.minecraft.class_10185;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1934;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2684;
import net.minecraft.class_2709;
import net.minecraft.class_2734;
import net.minecraft.class_2735;
import net.minecraft.class_2739;
import net.minecraft.class_2769;
import net.minecraft.class_2846;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5217;
import net.minecraft.class_5322;
import net.minecraft.class_7225;
import net.minecraft.class_8104;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import net.minecraft.class_8792;
import net.minecraft.class_8942;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.class_9812;
import net.minecraft.server.MinecraftServer;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ComputerModel
extends BlockModel {
    public static final int DISPLAY_WIDTH = 160;
    public static final int DISPLAY_HEIGHT = 144;
    public static final Map<UUID, ComputerModel> controlledComputers = new HashMap<UUID, ComputerModel>();
    public static final Map<class_2338, BufferedImage> renderedFrames = new HashMap<class_2338, BufferedImage>();
    private final class_1799 screen;
    private final ItemDisplayElement display;
    public final InteractionElement interaction;
    public final TextDisplayElement camera;
    public final TextDisplayElement debug;
    private final SimpleEntityElement horse;
    private final ItemDisplayElement main;
    private final ItemDisplayElement[] hotbar = new ItemDisplayElement[9];
    private final DataTrackerLike displayDataTracker = new SimpleDataTracker(class_1299.field_42456);
    private final AtomicBoolean rendering = new AtomicBoolean(false);
    private final class_2338 blockPos;
    private UUID controllerUUID;
    private FakePlayer fakePlayer;
    private boolean usingItem = false;
    private boolean showDebug = false;
    private final ArrayDeque<Long> frameTimes = new ArrayDeque();

    public ComputerModel(class_2338 blockPos, class_2680 blockState) {
        this.blockPos = blockPos;
        this.screen = new class_1799((class_1935)class_1802.field_47315);
        this.screen.method_57379(class_9334.field_54199, (Object)NotEnoughMinecraft.id("screen"));
        this.display = new ItemDisplayElement(this.screen);
        this.display.setBrightness(class_8104.field_42264);
        this.display.setViewRange(0.1f);
        for (int i = 0; i < 9; ++i) {
            this.hotbar[i] = ItemDisplayElementUtil.createSimple((class_1792)class_1802.field_20391);
            this.hotbar[i].setItemDisplayContext(class_811.field_4317);
            this.addElement((VirtualElement)this.hotbar[i]);
        }
        this.main = ItemDisplayElementUtil.createSimple((class_1792)ModItems.COMPUTER);
        this.camera = new TextDisplayElement();
        this.debug = new TextDisplayElement();
        this.debug.setBackground(0);
        this.debug.setTextAlignment(class_8113.class_8123.class_8124.field_42451);
        this.clearScreen();
        this.horse = new SimpleEntityElement(class_1299.field_6139);
        this.horse.setInvisible(true);
        this.horse.setOffset(new class_243(0.0, 256.0, 0.0));
        this.addElement((VirtualElement)this.horse);
        this.interaction = new InteractionElement(new VirtualElement.InteractionHandler(){

            public void interact(class_3222 player, class_1268 hand) {
                if (hand != class_1268.field_5808) {
                    return;
                }
                if (player.method_5667() == ComputerModel.this.controllerUUID) {
                    PlayerAction.USE.perform((class_3222)ComputerModel.this.fakePlayer);
                    ComputerModel.this.usingItem = true;
                }
            }

            public void attack(class_3222 player) {
                if (player.method_5667() == ComputerModel.this.controllerUUID) {
                    PlayerAction.ATTACK.perform((class_3222)ComputerModel.this.fakePlayer);
                }
            }

            public void pickItem(class_3222 player, boolean includeData) {
                if (player.method_5667() == ComputerModel.this.controllerUUID) {
                    PlayerAction.PICK_ITEM.perform((class_3222)ComputerModel.this.fakePlayer);
                }
            }
        });
        this.interaction.setSize(1.1f, 1.1f);
        this.interaction.setOffset(new class_243(0.0, -0.5, 0.0));
        this.addElement((VirtualElement)this.main);
        this.addElement((VirtualElement)this.display);
        this.addElement((VirtualElement)this.camera);
        this.updateBlockState(blockState);
    }

    private void updateBlockState(class_2680 blockState) {
        class_2350 dir = (class_2350)blockState.method_11654((class_2769)ComputerBlock.field_11177);
        float yaw = 180.0f - class_3532.method_15393((float)dir.method_10144());
        Quaternionf rotation = new Quaternionf();
        rotation.rotateY((float)Math.toRadians(yaw));
        for (int i = 0; i < 9; ++i) {
            Matrix4f hotbarTransformation = new Matrix4f();
            hotbarTransformation.rotate((Quaternionfc)rotation);
            hotbarTransformation.translate((float)i / 14.0f - 0.28f, -0.25f, 0.35625f);
            hotbarTransformation.scale(0.05f);
            this.hotbar[i].setTransformation(hotbarTransformation);
        }
        Matrix4f debugTransformation = new Matrix4f();
        debugTransformation.rotate((Quaternionfc)rotation);
        debugTransformation.translate(-0.26f, 0.1875f, 0.35625f);
        debugTransformation.scale(0.2f);
        this.debug.setTransformation(debugTransformation);
        Matrix4f displayTransform = new Matrix4f();
        displayTransform.rotate((Quaternionfc)rotation);
        displayTransform.translate(0.0f, -0.0625f, 0.34375f);
        displayTransform.scale(0.8f, 0.8f, 1.0f);
        this.display.setTransformation(displayTransform);
        Matrix4f mainTransform = new Matrix4f();
        mainTransform.rotate((Quaternionfc)rotation);
        this.main.setTransformation(mainTransform);
        Vector3f offset = new Vector3f(0.0f, 0.0f, 1.0f).rotate((Quaternionfc)rotation);
        this.camera.setOffset(new class_243(offset));
        this.camera.setRotation(0.0f, 180.0f - yaw);
    }

    public void notifyUpdate(HolderAttachment.UpdateType updateType) {
        if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
            this.updateBlockState(this.blockState());
        }
    }

    public boolean interact(class_3222 player) {
        if (this.controllerUUID == null) {
            this.setCamera(player);
            this.setController(player);
            return true;
        }
        return false;
    }

    private void setCamera(class_3222 controller) {
        controller.field_13987.method_14364((class_2596)VirtualEntityUtils.createSetCameraEntityPacket((int)this.camera.getEntityId()));
        controller.field_13987.method_14364((class_2596)VirtualEntityUtils.createRidePacket((int)this.horse.getEntityId(), (int[])new int[]{controller.method_5628()}));
        controller.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)class_1934.field_9219.method_8379()));
        controller.field_13987.method_14364((class_2596)new class_2684.class_2687(controller.method_5628(), 0, 0, controller.method_24828()));
        controller.field_13987.method_14364((class_2596)new class_2739(controller.method_5628(), List.of(class_2945.class_7834.method_46360((class_2940)EntityTrackedData.POSE, (Object)class_4050.field_18076))));
        controller.field_13987.method_14364((class_2596)new class_2735(0));
    }

    private void removeCamera(class_3222 controller) {
        controller.field_13987.method_14364((class_2596)new class_2734((class_1297)controller));
        controller.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25648, (float)controller.method_68876().method_8379()));
        controller.field_13987.method_14364((class_2596)VirtualEntityUtils.createRidePacket((int)this.horse.getEntityId(), (int[])new int[0]));
        controller.field_13987.method_14360(class_10182.method_63638((class_1297)controller), EnumSet.noneOf(class_2709.class));
        controller.field_13987.method_14364((class_2596)new class_2735(controller.method_31548().method_67532()));
    }

    protected void onTick() {
        super.onTick();
        HolderAttachment attachment = this.getAttachment();
        if (this.controllerUUID == null || this.fakePlayer == null || attachment == null) {
            return;
        }
        class_3218 level = attachment.getWorld();
        MinecraftServer server = level.method_8503();
        class_3222 controller = server.method_3760().method_14602(this.controllerUUID);
        if (controller == null || controller.method_51469() != level) {
            this.removeController(this.fakePlayer);
            return;
        }
        if (controller.method_5707(attachment.getPos()) >= 36.0) {
            this.removeCamera(controller);
            this.removeController(this.fakePlayer);
            return;
        }
        class_10185 input = controller.method_63562();
        if (input.comp_3164()) {
            this.removeCamera(controller);
            this.removeController(this.fakePlayer);
            return;
        }
        this.renderImage(this.fakePlayer);
        this.updateFps();
        this.renderHotbar(this.fakePlayer);
        this.setFakePlayerInput(this.fakePlayer, input);
        this.updateBlockState(this.blockState());
    }

    protected void onAttachmentRemoved(HolderAttachment oldAttachment) {
        super.onAttachmentRemoved(oldAttachment);
        if (this.controllerUUID != null) {
            class_3222 controller = this.fakePlayer.method_51469().method_8503().method_3760().method_14602(this.controllerUUID);
            if (controller != null) {
                this.removeCamera(controller);
            }
            this.removeController(this.fakePlayer);
        }
    }

    private void setController(class_3222 controller) {
        UUID uuid = controller.method_5667();
        UUID fakeUUID = new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits() + 1L);
        Object fakeName = "." + controller.method_5820();
        if (((String)fakeName).length() > 16) {
            fakeName = ((String)fakeName).substring(0, 16);
        }
        GameProfile fakeProfile = new GameProfile(fakeUUID, (String)fakeName);
        this.fakePlayer = new ComputerFakePlayer(controller.method_51469(), fakeProfile);
        MinecraftServer server = controller.method_51469().method_8503();
        class_5217.class_12064 respawnData = server.method_27728().method_27859().method_74893();
        Optional<class_11368> optional = server.method_3760().method_14600(this.fakePlayer.method_72498()).map(compoundTag -> class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)server.method_30611(), (class_2487)compoundTag));
        class_3222.class_11543 savedPosition = optional.flatMap(valueInput -> valueInput.method_71418(class_3222.class_11543.field_61094)).orElse(class_3222.class_11543.field_61095);
        class_3218 serverLevel = savedPosition.comp_4408().map(arg_0 -> ((MinecraftServer)server).method_3847(arg_0)).orElseGet(() -> {
            class_3218 respawnLevel = server.method_3847(respawnData.method_74894());
            return respawnLevel != null ? respawnLevel : server.method_30002();
        });
        class_243 spawnPosition = savedPosition.comp_4409().orElseGet(() -> (class_243)class_5322.method_72259((class_3218)serverLevel, (class_2338)respawnData.method_74897()).join());
        class_241 spawnAngle = savedPosition.comp_4410().orElse(new class_241(respawnData.comp_4916(), respawnData.comp_4917()));
        optional.ifPresent(arg_0 -> ((FakePlayer)this.fakePlayer).method_5651(arg_0));
        this.fakePlayer.method_60949(spawnPosition, spawnAngle.field_1343, spawnAngle.field_1342);
        server.method_3760().method_14570((class_2535)new FakeClientConnection(class_2598.field_11941), (class_3222)this.fakePlayer, new class_8792(this.fakePlayer.method_7334(), 0, this.fakePlayer.method_53823(), false));
        class_2168 source = server.method_3739().method_9217().method_9232((class_1297)this.fakePlayer);
        for (String spawnCommand : ModConfig.getInstance().spawnCommands) {
            spawnCommand = spawnCommand.replace("${controller}", controller.method_5820()).replace("${fake_player}", this.fakePlayer.method_5820());
            server.method_3734().method_44252(source, spawnCommand);
        }
        this.addElement((VirtualElement)this.interaction);
        this.controllerUUID = controller.method_5667();
        controlledComputers.put(this.controllerUUID, this);
    }

    private void removeController(FakePlayer fakePlayer) {
        fakePlayer.field_13987.method_10839(new class_9812((class_2561)class_2561.method_43470((String)"Remove Fake Player")));
        controlledComputers.remove(this.controllerUUID);
        renderedFrames.remove(this.blockPos);
        this.fakePlayer = null;
        this.controllerUUID = null;
        this.removeElement((VirtualElement)this.interaction);
        this.clearScreen();
    }

    public void onCameraMove(float yRot, float xRot) {
        float currentYRot = this.fakePlayer.method_5791();
        float currentXRot = this.fakePlayer.method_36455();
        this.fakePlayer.method_5847(yRot + currentYRot);
        this.fakePlayer.method_36457(xRot + currentXRot);
        this.fakePlayer.method_5636(yRot + currentYRot);
        this.fakePlayer.method_36456(yRot + currentYRot);
    }

    public void setSelectedSlot(int selectedSlot) {
        this.fakePlayer.method_31548().method_61496(selectedSlot);
    }

    public void onInventoryOpen() {
        if (this.showDebug) {
            this.removeElement((VirtualElement)this.debug);
        } else {
            this.addElement((VirtualElement)this.debug);
        }
        this.showDebug = !this.showDebug;
    }

    public void onPlayerAction(class_2846.class_2847 action) {
        switch (action) {
            case field_12975: {
                PlayerAction.DROP.perform((class_3222)this.fakePlayer);
                break;
            }
            case field_12970: {
                PlayerAction.DROP_ALL.perform((class_3222)this.fakePlayer);
            }
        }
    }

    private void setFakePlayerInput(FakePlayer fakePlayer, class_10185 input) {
        fakePlayer.method_5728(input.comp_3165());
        if (input.comp_3163()) {
            PlayerAction.JUMP.perform((class_3222)fakePlayer);
        }
        float velocity = input.comp_3164() ? 0.3f : 1.0f;
        fakePlayer.field_6212 = 0.0f;
        fakePlayer.field_6250 = 0.0f;
        if (input.comp_3159()) {
            fakePlayer.field_6250 += velocity;
        }
        if (input.comp_3160()) {
            fakePlayer.field_6250 -= velocity;
        }
        if (input.comp_3161()) {
            fakePlayer.field_6212 += velocity;
        }
        if (input.comp_3162()) {
            fakePlayer.field_6212 -= velocity;
        }
    }

    private void renderImage(FakePlayer fakePlayer) {
        if (!this.rendering.compareAndSet(false, true)) {
            return;
        }
        ImageRenderer renderer = new ImageRenderer((class_1309)fakePlayer, 160, 144, ModConfig.getInstance().renderDistance);
        CompletableFuture.supplyAsync(renderer::render).thenAcceptAsync(pixels -> {
            try {
                if (this.controllerUUID == null) {
                    return;
                }
                this.updateScreen((int[])pixels, false);
                this.frameTimes.addLast(System.currentTimeMillis());
                this.saveFrame((int[])pixels);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                this.rendering.set(false);
            }
        }, (Executor)fakePlayer.method_51469().method_8503());
    }

    private void saveFrame(int[] pixels) {
        class_2338 blockPos = this.blockPos();
        int width = 160;
        int height = 144;
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] texture = new int[width * height];
        System.arraycopy(pixels, 0, texture, 0, texture.length);
        for (int y = 0; y < height; ++y) {
            int rowStart = y * width;
            int rowEnd = rowStart + width - 1;
            for (int x = 0; x < width; ++x) {
                texture[rowStart + x] = pixels[rowEnd - x];
            }
        }
        image.setRGB(0, 0, width, height, texture, 0, width);
        renderedFrames.put(blockPos, image);
    }

    private void updateFps() {
        long now = System.currentTimeMillis();
        long cutoff = now - 1000L;
        while (!this.frameTimes.isEmpty() && this.frameTimes.getFirst() < cutoff) {
            this.frameTimes.removeFirst();
        }
        this.debug.setText((class_2561)class_2561.method_43470((String)("FPS: " + this.frameTimes.size())));
    }

    private void renderHotbar(FakePlayer fakePlayer) {
        class_1661 inventory = fakePlayer.method_31548();
        int selectedSlot = inventory.method_67532();
        for (int i = 0; i < 9; ++i) {
            class_1799 item = inventory.method_5438(i);
            if (item.method_7960()) {
                item = new class_1799((class_1935)class_1802.field_8077);
            }
            this.hotbar[i].setItem(item);
            this.hotbar[i].setGlowing(selectedSlot == i);
        }
    }

    private void clearScreen() {
        this.updateScreen(new int[23040], true);
        for (int i = 0; i < 9; ++i) {
            this.hotbar[i].setItem(class_1799.field_8037);
        }
        this.debug.setText((class_2561)class_2561.method_43470((String)""));
    }

    private void updateScreen(int[] pixels, boolean forceUpdate) {
        class_9280 customModelData = new class_9280(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (List)IntArrayList.wrap((int[])pixels));
        this.screen.method_57379(class_9334.field_49637, (Object)customModelData);
        this.displayDataTracker.set(DisplayTrackedData.Item.ITEM, (Object)this.screen, true);
        for (class_3244 watchingPlayer : this.getWatchingPlayers()) {
            if (!forceUpdate && !(watchingPlayer.field_14140.method_5707(this.blockPos.method_61082()) <= 36.0)) continue;
            watchingPlayer.method_14364((class_2596)new class_2739(this.display.getEntityId(), this.displayDataTracker.getChangedEntries()));
        }
    }
}

