/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu;

import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.util.EnumToLowerCaseJsonConverter;
import com.terraformersmc.mod_menu.util.ModMenuScreenTexts;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.fabric.FabricMod;
import com.terraformersmc.mod_menu.util.mod.java.JavaDummyMod;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeDummyParentMod;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeMod;
import java.awt.Color;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Pair;
import org.sinytra.connector.loader.ConnectorEarlyLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMenu {
    public static final String MOD_ID = "mod_menu";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu");
    public static final Gson GSON;
    public static final Gson GSON_MINIFIED;
    public static final Pair<ModMenuConfig, ForgeConfigSpec> CONFIG;
    public static boolean shouldResetCache;
    public static final Map<String, Mod> MODS;
    public static final Map<String, Mod> ROOT_MODS;
    public static final LinkedListMultimap<Mod, Mod> PARENT_MAP;
    public static final Map<String, BiFunction<Minecraft, Screen, Screen>> configScreenFactories;
    private static int cachedDisplayedModCount;
    public static final boolean HAS_SINYTRA;

    public static boolean hasConfigScreen(ModContainer container) {
        return ModMenu.getConfigScreenFactory(container) != null;
    }

    @Nullable
    public static Screen getConfigScreen(ModContainer container, Screen parent) {
        BiFunction<Minecraft, Screen, Screen> factory = ModMenu.getConfigScreenFactory(container);
        if (factory != null) {
            return factory.apply(Minecraft.m_91087_(), parent);
        }
        return null;
    }

    @Nullable
    private static BiFunction<Minecraft, Screen, Screen> getConfigScreenFactory(ModContainer container) {
        if (((List)ModMenu.getConfig().HIDDEN_CONFIGS.get()).contains(container.getModId()) || "java".equals(container.getModId())) {
            return null;
        }
        configScreenFactories.putIfAbsent("minecraft", (modContainer, screen) -> new OptionsScreen(screen, Minecraft.m_91087_().f_91066_));
        Optional factoryOptional = ConfigScreenHandler.getScreenFactoryFor((IModInfo)container.getModInfo());
        factoryOptional.ifPresent(f -> configScreenFactories.putIfAbsent(container.getModId(), (BiFunction<Minecraft, Screen, Screen>)f));
        return configScreenFactories.get(container.getModId());
    }

    public ModMenu() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::onClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CONFIG.getValue());
        ModList.get().forEachModContainer((s, modContainer) -> {
            Mod mod = HAS_SINYTRA && ConnectorEarlyLoader.isConnectorMod((String)modContainer.getModId()) ? new FabricMod(modContainer.getModId()) : new NeoforgeMod((ModContainer)modContainer);
            MODS.put(mod.getId(), mod);
        });
        HashMap<String, Mod> dummyParents = new HashMap<String, Mod>();
        HashSet<String> modParentSet = new HashSet<String>();
        for (Mod mod : MODS.values()) {
            Mod parent;
            String parentId = mod.getParent();
            if (parentId == null) {
                ROOT_MODS.put(mod.getId(), mod);
                continue;
            }
            modParentSet.clear();
            while (true) {
                if ((parent = MODS.getOrDefault(parentId, (Mod)dummyParents.get(parentId))) == null) {
                    parent = new NeoforgeDummyParentMod(mod, parentId);
                    dummyParents.put(parentId, parent);
                }
                String string = parentId = parent != null ? parent.getParent() : null;
                if (parentId == null) break;
                if (modParentSet.contains(parentId)) {
                    LOGGER.warn("Mods contain each other as parents: {}", modParentSet);
                    parent = null;
                    break;
                }
                modParentSet.add(parentId);
            }
            if (parent == null) {
                ROOT_MODS.put(mod.getId(), mod);
                continue;
            }
            PARENT_MAP.put((Object)parent, (Object)mod);
        }
        JavaDummyMod java = new JavaDummyMod();
        MODS.put("java", java);
        ROOT_MODS.put("java", java);
        MODS.putAll(dummyParents);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        ModMenu.getConfig().onLoad();
    }

    public static void clearModCountCache() {
        cachedDisplayedModCount = -1;
    }

    public static String getDisplayedModCount() {
        if (cachedDisplayedModCount == -1) {
            boolean includeChildren = (Boolean)ModMenu.getConfig().COUNT_CHILDREN.get();
            boolean includeLibraries = (Boolean)ModMenu.getConfig().COUNT_LIBRARIES.get();
            boolean includeHidden = (Boolean)ModMenu.getConfig().COUNT_HIDDEN_MODS.get();
            cachedDisplayedModCount = Math.toIntExact(MODS.values().stream().filter(mod -> {
                boolean isChild;
                boolean bl = isChild = mod.getParent() != null;
                if (!includeChildren && isChild) {
                    return false;
                }
                boolean isLibrary = mod.getBadges().contains(ModBadge.LIBRARY);
                if (!includeLibraries && isLibrary) {
                    return false;
                }
                return includeHidden || !mod.isHidden();
            }).count());
        }
        return NumberFormat.getInstance().format(cachedDisplayedModCount);
    }

    public static Component createModsButtonText(boolean title) {
        boolean isIcon;
        ModMenuConfig.TitleMenuButtonStyle titleStyle = (ModMenuConfig.TitleMenuButtonStyle)((Object)ModMenu.getConfig().MODS_BUTTON_STYLE.get());
        ModMenuConfig.GameMenuButtonStyle gameMenuStyle = (ModMenuConfig.GameMenuButtonStyle)((Object)ModMenu.getConfig().GAME_MENU_BUTTON_STYLE.get());
        boolean bl = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.ICON : (isIcon = gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.ICON);
        boolean isShort = title ? titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK || titleStyle == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT : gameMenuStyle == ModMenuConfig.GameMenuButtonStyle.REPLACE;
        MutableComponent modsText = ModMenuScreenTexts.TITLE.m_6881_();
        if (((ModMenuConfig.ModCountLocation)((Object)ModMenu.getConfig().MOD_COUNT_LOCATION.get())).isOnModsButton() && !isIcon) {
            String count = ModMenu.getDisplayedModCount();
            if (isShort) {
                modsText.m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)"mod_menu.loaded.short", (Object[])new Object[]{count}));
            } else {
                Object key;
                String specificKey = "mod_menu.loaded." + count;
                Object object = key = I18n.m_118936_((String)specificKey) ? specificKey : "mod_menu.loaded";
                if (((Boolean)ModMenu.getConfig().EASTER_EGGS.get()).booleanValue() && I18n.m_118936_((String)(specificKey + ".secret"))) {
                    key = specificKey + ".secret";
                }
                modsText.m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Component.m_237110_((String)key, (Object[])new Object[]{count}));
            }
        }
        return modsText;
    }

    public static ModMenuConfig getConfig() {
        return (ModMenuConfig)CONFIG.getLeft();
    }

    public static void createBadgesAndIcons() {
        ModBadge.CUSTOM_BADGES.clear();
        NeoforgeIconHandler.modResourceIconCache.clear();
        Stream resourcePacks = Minecraft.m_91087_().m_91098_().m_7536_();
        resourcePacks.forEach(packResources -> packResources.m_5698_(PackType.CLIENT_RESOURCES).forEach(namespace -> {
            packResources.m_8031_(PackType.CLIENT_RESOURCES, namespace, "badge", (key, value) -> {
                try {
                    JsonArray textColor;
                    JsonObject jsonObject = GsonHelper.m_13859_((Reader)new InputStreamReader((InputStream)value.m_247737_()));
                    JsonArray fillColor = jsonObject.getAsJsonArray("fill_color");
                    JsonArray outlineColor = jsonObject.getAsJsonArray("outline_color");
                    try {
                        textColor = jsonObject.getAsJsonArray("text_color");
                    }
                    catch (Exception ignored) {
                        textColor = null;
                    }
                    String id = key.m_135815_().replace("badge/", "").replace(".json", "");
                    ModBadge badge = new ModBadge(jsonObject.get("name").getAsString(), new Color(outlineColor.get(0).getAsInt(), outlineColor.get(1).getAsInt(), outlineColor.get(2).getAsInt()).getRGB(), new Color(fillColor.get(0).getAsInt(), fillColor.get(1).getAsInt(), fillColor.get(2).getAsInt()).getRGB(), textColor == null ? -3487030 : new Color(textColor.get(0).getAsInt(), textColor.get(1).getAsInt(), textColor.get(2).getAsInt()).getRGB());
                    ModBadge.CUSTOM_BADGES.put(id, badge);
                }
                catch (Exception e) {
                    LOGGER.warn("incorrect badge json from {} because {}", key, (Object)e.getMessage());
                }
            });
            packResources.m_8031_(PackType.CLIENT_RESOURCES, namespace, "modicon", (key, value) -> {
                try {
                    NativeImage image = NativeImage.m_85058_((InputStream)((InputStream)value.m_247737_()));
                    Tuple tex = new Tuple((Object)new DynamicTexture(image), (Object)new Dimension(image.m_84982_(), image.m_85084_()));
                    String id = key.m_135815_().replace("modicon/", "").replace(".png", "");
                    NeoforgeIconHandler.modResourceIconCache.put(id, (Tuple<DynamicTexture, Dimension>)tex);
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            });
        }));
        shouldResetCache = true;
        MODS.values().forEach(Mod::reCalculateBadge);
    }

    static {
        shouldResetCache = false;
        GsonBuilder builder = new GsonBuilder().registerTypeHierarchyAdapter(Enum.class, (Object)new EnumToLowerCaseJsonConverter()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        GSON = builder.setPrettyPrinting().create();
        GSON_MINIFIED = builder.create();
        CONFIG = new ForgeConfigSpec.Builder().configure(ModMenuConfig::new);
        MODS = new HashMap<String, Mod>();
        ROOT_MODS = new HashMap<String, Mod>();
        PARENT_MAP = LinkedListMultimap.create();
        configScreenFactories = new HashMap<String, BiFunction<Minecraft, Screen, Screen>>();
        cachedDisplayedModCount = -1;
        HAS_SINYTRA = ModList.get().isLoaded("connectormod");
    }
}

