/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.mod_menu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.mod_menu.util.CompatUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mod_menu", value={Dist.CLIENT})
public class ModMenuEventHandler {
    public static final ResourceLocation MODS_BUTTON_TEXTURE = new ResourceLocation("mod_menu", "textures/gui/mods_button.png");
    private static final Lazy<KeyMapping> MENU_KEY_BIND = Lazy.of(() -> new KeyMapping("key.modmenu.open_menu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.categories.misc"));

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen && ((Boolean)ModMenu.getConfig().MODIFY_TITLE_SCREEN.get()).booleanValue() && !CompatUtils.isCustomMenu()) {
            ModMenuEventHandler.removeModsButton(screen);
            ModMenuEventHandler.afterTitleScreenInit(screen);
        }
    }

    private static void removeModsButton(Screen screen) {
        screen.f_169369_.forEach(renderable -> {
            if (ModMenuEventHandler.buttonHasText((LayoutElement)renderable, "fml.menu.mods") && renderable instanceof Button) {
                Button button = (Button)renderable;
                button.f_93624_ = false;
                button.f_93623_ = false;
            }
        });
    }

    private static void afterTitleScreenInit(Screen screen) {
        List buttons = screen.f_169369_;
        int modsButtonIndex = -1;
        int spacing = 24;
        int buttonsY = screen.f_96544_ / 4 + 48;
        for (int i = 0; i < buttons.size(); ++i) {
            Button button2;
            Renderable widget = (Renderable)buttons.get(i);
            if (!(widget instanceof Button) || (button2 = (Button)widget) instanceof PlainTextButton) continue;
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC && button2.f_93624_) {
                ModMenuEventHandler.shiftButtons((LayoutElement)button2, modsButtonIndex == -1, 24);
                if (modsButtonIndex == -1) {
                    buttonsY = button2.m_252907_();
                }
            }
            if (ModMenuEventHandler.buttonHasText((LayoutElement)button2, "menu.online")) {
                if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC || ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                    button2.m_93674_(200);
                    button2.m_252865_(screen.f_96543_ / 2 - 100);
                }
                if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
                    ModMenuEventHandler.set(screen, i, (AbstractWidget)new ModMenuButtonWidget(button2.m_252754_() - 102, button2.m_252907_(), 200, button2.m_93694_(), ModMenu.createModsButtonText(true), screen));
                } else {
                    if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                        button2.m_93674_(98);
                    } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                        button2.m_93674_(98);
                        button2.m_252865_(screen.f_96543_ / 2 + 2);
                    }
                    modsButtonIndex = i + 1;
                    if (button2.f_93624_) {
                        buttonsY = button2.m_252907_();
                    }
                }
            }
            if (modsButtonIndex != -1 || !ModMenuEventHandler.buttonHasText((LayoutElement)button2, "fml.menu.mods")) continue;
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() != ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                buttonsY = button2.m_252907_();
            }
            modsButtonIndex = i;
        }
        if (modsButtonIndex != -1) {
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.f_96543_ / 2 - 100, buttonsY + 24, 200, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.f_96543_ / 2 - 100, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.f_96543_ / 2 - 100, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new UpdateCheckerTexturedButtonWidget(screen.f_96543_ / 2 + 104, buttonsY, 20, 20, 0, 0, 20, MODS_BUTTON_TEXTURE, 32, 64, button -> Minecraft.m_91087_().m_91152_((Screen)new ModsScreen(screen)), ModMenu.createModsButtonText(true)));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        while (((KeyMapping)MENU_KEY_BIND.get()).m_90859_()) {
            Minecraft.m_91087_().m_91152_((Screen)new ModsScreen(Minecraft.m_91087_().f_91080_));
        }
    }

    public static boolean buttonHasText(LayoutElement element, String ... translationKeys) {
        if (element instanceof Button) {
            Button button = (Button)element;
            Component component = button.m_6035_();
            ComponentContents textContent = component.m_214077_();
            return textContent instanceof TranslatableContents && Arrays.stream(translationKeys).anyMatch(s -> ((TranslatableContents)textContent).m_237508_().equals(s));
        }
        return false;
    }

    public static void shiftButtons(LayoutElement element, boolean shiftUp, int spacing) {
        AbstractWidget button;
        if (shiftUp) {
            element.m_253211_(element.m_252907_() - spacing / 2);
        } else if (!(element instanceof AbstractWidget) || !(button = (AbstractWidget)element).m_6035_().equals(Component.m_237115_((String)"title.credits"))) {
            element.m_253211_(element.m_252907_() + spacing / 2);
        }
    }

    public static AbstractWidget set(Screen screen, int index, AbstractWidget element) {
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.f_169369_, index, false);
        screen.f_169369_.set(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.f_169368_, index, false);
        screen.f_169368_.set(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.f_96540_, index, false);
        return screen.f_96540_.set(childIndex, element);
    }

    public static void add(Screen screen, int index, AbstractWidget element) {
        int duplicateIndex = screen.f_169369_.indexOf(element);
        if (duplicateIndex >= 0) {
            screen.f_169369_.remove(element);
            screen.f_169368_.remove(element);
            screen.f_96540_.remove(element);
            if (duplicateIndex <= ModMenuEventHandler.translateIndex(screen.f_169369_, index, true)) {
                --index;
            }
        }
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.f_169369_, index, true);
        screen.f_169369_.add(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.f_169368_, index, true);
        screen.f_169368_.add(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.f_96540_, index, true);
        screen.f_96540_.add(childIndex, element);
    }

    private static int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof AbstractWidget)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }

    @Mod.EventBusSubscriber(modid="mod_menu", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class modBusEvents {
        @SubscribeEvent
        public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)MENU_KEY_BIND.get());
        }

        @SubscribeEvent
        public static void registerReloadManager(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> ModMenu.createBadgesAndIcons()));
        }
    }
}

