/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.mixin;

import com.google.common.collect.Lists;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.internal.BrandingControl;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BrandingControl.class})
public abstract class MixinBrandingControl {
    @Shadow(remap=false)
    private static List<String> brandings;
    @Shadow(remap=false)
    private static List<String> brandingsNoMC;

    @Shadow(remap=false)
    private static void computeBranding() {
    }

    @Inject(method={"forEachLine"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void replaceBranding(boolean includeMC, boolean reverse, BiConsumer<Integer, String> lineConsumer, CallbackInfo ci) {
        if (((Boolean)ModMenu.getConfig().MODIFY_TITLE_SCREEN.get()).booleanValue()) {
            List<String> brandings = MixinBrandingControl.forge_mod_menu$getBrandings(includeMC, reverse);
            String forge = brandings.get(0);
            if (((ModMenuConfig.ModCountLocation)((Object)ModMenu.getConfig().MOD_COUNT_LOCATION.get())).isOnTitleScreen()) {
                Object replacementKey;
                String count = ModMenu.getDisplayedModCount();
                String specificKey = "mod_menu.mods." + count;
                Object object = replacementKey = I18n.m_118936_((String)specificKey) ? specificKey : "mod_menu.mods.n";
                if (((Boolean)ModMenu.getConfig().EASTER_EGGS.get()).booleanValue() && I18n.m_118936_((String)(specificKey + ".secret"))) {
                    replacementKey = specificKey + ".secret";
                }
                forge = forge.replace(I18n.m_118938_((String)"fml.menu.branding", (Object[])new Object[]{"", ModList.get().size()}), I18n.m_118938_((String)replacementKey, (Object[])new Object[]{count}));
            } else {
                forge = forge.replace(I18n.m_118938_((String)"fml.menu.branding", (Object[])new Object[]{"", ModList.get().size()}), I18n.m_118938_((String)"menu.modded", (Object[])new Object[0]));
            }
            lineConsumer.accept(0, forge);
            lineConsumer.accept(1, brandings.get(1));
            ci.cancel();
        }
    }

    @Unique
    private static List<String> forge_mod_menu$getBrandings(boolean includeMC, boolean reverse) {
        MixinBrandingControl.computeBranding();
        if (includeMC) {
            return reverse ? Lists.reverse(brandings) : brandings;
        }
        return reverse ? Lists.reverse(brandingsNoMC) : brandingsNoMC;
    }
}

