/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod;

import com.terraformersmc.mod_menu.ModMenu;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;

public class ModBadge {
    private final Component component;
    private final int fillColor;
    private final int outlineColor;
    private final int textColor;
    public static ModBadge LIBRARY = new ModBadge("mod_menu.badge.library", -15698860, -16172759);
    public static Map<String, ModBadge> DEFAULT_BADGES = Map.of("library", LIBRARY, "client", new ModBadge("mod_menu.badge.clientsideOnly", -13939844, -15848875), "deprecated", new ModBadge("mod_menu.badge.deprecated", -8121306, -11334633), "sinytra_fabric", new ModBadge("mod_menu.badge.fabric", -3689333, -8884904), "forge", new ModBadge("mod_menu.badge.forge", -12825245, -14274499), "modpack", new ModBadge("mod_menu.badge.modpack", -8770692, -11465388), "minecraft", new ModBadge("mod_menu.badge.minecraft", -9474966, -13553617));
    public static Map<String, ModBadge> CUSTOM_BADGES = new LinkedHashMap<String, ModBadge>();
    public static List<Map<String, ModBadge>> BADGES = List.of(DEFAULT_BADGES, CUSTOM_BADGES);

    public ModBadge(String displayName, int outlineColor, int fillColor) {
        this(displayName, outlineColor, fillColor, 0xCACACA);
    }

    public ModBadge(String displayName, int outlineColor, int fillColor, int textColor) {
        this.component = Component.m_237115_((String)displayName);
        this.fillColor = fillColor;
        this.outlineColor = outlineColor;
        this.textColor = textColor;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getOutlineColor() {
        return this.outlineColor;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public static Set<ModBadge> convert(Set<String> badgeKeys, String modId) {
        return badgeKeys.stream().map(key -> {
            if (DEFAULT_BADGES.containsKey(key)) {
                return DEFAULT_BADGES.get(key);
            }
            if (CUSTOM_BADGES.containsKey(key)) {
                return CUSTOM_BADGES.get(key);
            }
            ModMenu.LOGGER.warn("Skipping unknown badge key '{}' specified by mod '{}'", key, (Object)modId);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

