/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.util.mod.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.util.VersionUtil;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadge;
import com.terraformersmc.mod_menu.util.mod.neoforge.NeoforgeIconHandler;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaDummyMod
implements Mod {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu | NeoforgeMod");
    protected final Mod.ModMenuData modMenuData;
    private static final String modid = "java";
    protected final Map<String, String> links = new HashMap<String, String>();
    protected final Set<String> badgeNames = new LinkedHashSet<String>();
    protected boolean defaultIconWarning = true;
    protected boolean allowsUpdateChecks = false;
    protected boolean childHasUpdate = false;

    public JavaDummyMod() {
        Optional<String> parentId = Optional.empty();
        this.badgeNames.add("library");
        this.modMenuData = new Mod.ModMenuData(parentId, null, modid);
    }

    @Override
    @NotNull
    public String getId() {
        return modid;
    }

    @Override
    @NotNull
    public String getName() {
        return System.getProperty("java.vm.name");
    }

    @Override
    @NotNull
    public Tuple<DynamicTexture, Dimension> getIcon(NeoforgeIconHandler iconHandler, int i, boolean isSmall) {
        String iconSourceId = "mod_menu";
        String iconResourceId = iconSourceId + (isSmall ? "_small" : "");
        if (NeoforgeIconHandler.modResourceIconCache.containsKey(iconResourceId)) {
            return NeoforgeIconHandler.modResourceIconCache.get(iconResourceId);
        }
        String iconPath = "assets/mod_menu/java_icon.png";
        String finalIconSourceId = iconSourceId;
        ModContainer iconSource = (ModContainer)ModList.get().getModContainerById(iconSourceId).orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Neoforge mod with id " + finalIconSourceId));
        Tuple<DynamicTexture, Dimension> icon = iconHandler.createIcon(iconSource, iconPath);
        if (icon == null) {
            if (this.defaultIconWarning) {
                LOGGER.warn("Warning! Mod {} has a broken icon, loading default icon", (Object)modid);
                this.defaultIconWarning = false;
            }
            return iconHandler.createIcon((ModContainer)ModList.get().getModContainerById("mod_menu").orElseThrow(() -> new RuntimeException("Cannot get ModContainer for Neoforge mod with id mod_menu")), "assets/mod_menu/unknown_icon.png");
        }
        return icon;
    }

    @Override
    @NotNull
    public String getDescription() {
        return modid;
    }

    @Override
    @NotNull
    public String getTranslatedDescription() {
        Object description = Mod.super.getTranslatedDescription();
        description = (String)description + "\n" + I18n.m_118938_((String)"mod_menu.javaDistributionName", (Object[])new Object[]{this.getName()});
        return description;
    }

    @Override
    @NotNull
    public String getVersion() {
        return System.getProperty("java.runtime.version");
    }

    @Override
    @NotNull
    public String getPrefixedVersion() {
        return VersionUtil.getPrefixedVersion(this.getVersion());
    }

    @Override
    @NotNull
    public List<String> getAuthors() {
        return Lists.newArrayList((Object[])new String[]{System.getProperty("java.vendor")});
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getContributors() {
        return Map.of();
    }

    @Override
    @NotNull
    public SortedMap<String, Set<String>> getCredits() {
        return new TreeMap<String, Set<String>>();
    }

    @Override
    @NotNull
    public Set<ModBadge> getBadges() {
        return this.modMenuData.getBadges();
    }

    @Override
    @NotNull
    public Set<String> getBadgeNames() {
        return this.badgeNames;
    }

    @Override
    @Nullable
    public String getWebsite() {
        return System.getProperty("java.vendor.url");
    }

    @Override
    @Nullable
    public String getIssueTracker() {
        return null;
    }

    @Override
    @Nullable
    public String getSource() {
        return null;
    }

    @Override
    @Nullable
    public String getParent() {
        return null;
    }

    @Override
    @NotNull
    public Set<String> getLicense() {
        return Sets.newHashSet();
    }

    @Override
    @NotNull
    public Map<String, String> getLinks() {
        return Map.of();
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public Mod.ModMenuData getModMenuData() {
        return this.modMenuData;
    }

    @Override
    public boolean getChildHasUpdate() {
        return this.childHasUpdate;
    }

    @Override
    public void setChildHasUpdate() {
        this.childHasUpdate = true;
    }

    @Override
    public boolean isHidden() {
        return ((List)ModMenu.getConfig().HIDDEN_MODS.get()).contains(this.getId());
    }

    @Override
    public Optional<ModContainer> getContainer() {
        return Optional.empty();
    }
}

