/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.config.ModMenuConfig;
import com.terraformersmc.mod_menu.gui.ModsScreen;
import com.terraformersmc.mod_menu.gui.widget.ModMenuButtonWidget;
import com.terraformersmc.mod_menu.gui.widget.UpdateCheckerTexturedButtonWidget;
import com.terraformersmc.mod_menu.util.CompatUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.util.Lazy;

@EventBusSubscriber(modid="mod_menu", value={Dist.CLIENT})
public class ModMenuEventHandler {
    public static final ResourceLocation MODS_BUTTON_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mod_menu", (String)"textures/gui/mods_button.png");
    private static final Lazy<KeyMapping> MENU_KEY_BIND = Lazy.of(() -> new KeyMapping("key.modmenu.open_menu", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, -1, "key.categories.misc"));

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof TitleScreen && ((Boolean)ModMenu.getConfig().MODIFY_TITLE_SCREEN.get()).booleanValue() && !CompatUtils.isCustomMenu()) {
            ModMenuEventHandler.removeModsButton(screen);
            ModMenuEventHandler.afterTitleScreenInit(screen);
        }
    }

    private static void removeModsButton(Screen screen) {
        screen.renderables.forEach(renderable -> {
            if (ModMenuEventHandler.buttonHasText((LayoutElement)renderable, "fml.menu.mods") && renderable instanceof Button) {
                Button button = (Button)renderable;
                button.visible = false;
                button.active = false;
            }
        });
    }

    private static void afterTitleScreenInit(Screen screen) {
        List buttons = screen.renderables;
        int modsButtonIndex = -1;
        int spacing = 24;
        int buttonsY = screen.height / 4 + 48;
        boolean replacedRealmButton = false;
        for (int i = 0; i < buttons.size(); ++i) {
            Button button2;
            Renderable widget = (Renderable)buttons.get(i);
            if (!(widget instanceof Button) || (button2 = (Button)widget) instanceof PlainTextButton) continue;
            ModMenuEventHandler.shiftButtons((LayoutElement)button2, replacedRealmButton, 24 + (replacedRealmButton ? -12 : 8));
            boolean isRealmsButton = ModMenuEventHandler.buttonHasText((LayoutElement)button2, "menu.online");
            if (isRealmsButton) {
                replacedRealmButton = true;
            }
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC && button2.visible) {
                ModMenuEventHandler.shiftButtons((LayoutElement)button2, modsButtonIndex == -1, 24);
                if (modsButtonIndex == -1) {
                    buttonsY = button2.getY();
                }
            }
            if (isRealmsButton) {
                if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.REPLACE_REALMS) {
                    ModMenuEventHandler.set(screen, i, (AbstractWidget)new ModMenuButtonWidget(button2.getX(), button2.getY(), button2.getWidth(), button2.getHeight(), ModMenu.createModsButtonText(true), screen));
                } else {
                    if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                        button2.setWidth(98);
                    }
                    if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                        button2.setWidth(98);
                        button2.setX(screen.width / 2 + 2);
                    }
                    modsButtonIndex = i + 1;
                    if (button2.visible) {
                        buttonsY = button2.getY();
                    }
                }
            }
            if (modsButtonIndex != -1 || !ModMenuEventHandler.buttonHasText((LayoutElement)button2, "fml.menu.mods")) continue;
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() != ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                buttonsY = button2.getY();
            }
            modsButtonIndex = i;
        }
        if (modsButtonIndex != -1) {
            if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.CLASSIC) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 - 100, buttonsY + 24, 200, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 + 2, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.SHRINK_LEFT) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new ModMenuButtonWidget(screen.width / 2 - 100, buttonsY, 98, 20, ModMenu.createModsButtonText(true), screen));
            } else if (ModMenu.getConfig().MODS_BUTTON_STYLE.get() == ModMenuConfig.TitleMenuButtonStyle.ICON) {
                ModMenuEventHandler.add(screen, modsButtonIndex, (AbstractWidget)new UpdateCheckerTexturedButtonWidget(screen.width / 2 + 104, buttonsY, 20, 20, 0, 0, 20, MODS_BUTTON_TEXTURE, 32, 64, button -> Minecraft.getInstance().setScreen((Screen)new ModsScreen(screen)), ModMenu.createModsButtonText(true)));
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        while (((KeyMapping)MENU_KEY_BIND.get()).consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new ModsScreen(Minecraft.getInstance().screen));
        }
    }

    public static boolean buttonHasText(LayoutElement element, String ... translationKeys) {
        if (element instanceof Button) {
            Button button = (Button)element;
            Component component = button.getMessage();
            ComponentContents textContent = component.getContents();
            return textContent instanceof TranslatableContents && Arrays.stream(translationKeys).anyMatch(s -> ((TranslatableContents)textContent).getKey().equals(s));
        }
        return false;
    }

    public static void shiftButtons(LayoutElement element, boolean shiftUp, int spacing) {
        AbstractWidget button;
        if (shiftUp) {
            element.setY(element.getY() - spacing / 2);
        } else if (!(element instanceof AbstractWidget) || !(button = (AbstractWidget)element).getMessage().equals((Object)Component.translatable((String)"title.credits"))) {
            element.setY(element.getY() + spacing / 2);
        }
    }

    public static AbstractWidget set(Screen screen, int index, AbstractWidget element) {
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.renderables, index, false);
        screen.renderables.set(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.narratables, index, false);
        screen.narratables.set(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.children, index, false);
        return screen.children.set(childIndex, element);
    }

    public static void add(Screen screen, int index, AbstractWidget element) {
        int duplicateIndex = screen.renderables.indexOf(element);
        if (duplicateIndex >= 0) {
            screen.renderables.remove(element);
            screen.narratables.remove(element);
            screen.children.remove(element);
            if (duplicateIndex <= ModMenuEventHandler.translateIndex(screen.renderables, index, true)) {
                --index;
            }
        }
        int drawableIndex = ModMenuEventHandler.translateIndex(screen.renderables, index, true);
        screen.renderables.add(drawableIndex, element);
        int selectableIndex = ModMenuEventHandler.translateIndex(screen.narratables, index, true);
        screen.narratables.add(selectableIndex, element);
        int childIndex = ModMenuEventHandler.translateIndex(screen.children, index, true);
        screen.children.add(childIndex, element);
    }

    private static int translateIndex(List<?> list, int index, boolean allowAfter) {
        int remaining = index;
        int max = list.size();
        for (int i = 0; i < max; ++i) {
            if (!(list.get(i) instanceof AbstractWidget)) continue;
            if (remaining == 0) {
                return i;
            }
            --remaining;
        }
        if (allowAfter && remaining == 0) {
            return list.size();
        }
        throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", index, index - remaining));
    }

    @EventBusSubscriber(modid="mod_menu", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class modBusEvents {
        @SubscribeEvent
        public static void registerKeyMapping(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)MENU_KEY_BIND.get());
        }

        @SubscribeEvent
        public static void registerReloadManager(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> ModMenu.createBadgesAndIcons()));
        }
    }
}

